/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpResource;
import at.mrdevelopment.toolkit.http.StaticFileHttpRequestHandler;
import at.mrdevelopment.toolkit.http.StaticFileHttpResource;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DynamicXmlHttpResource
implements HttpResource {
    static ESLLogger logger = ESLLogger.getLogger(DynamicXmlHttpResource.class);
    private final String stylesheet;
    private final XMLToolkit toolkit;
    private final Document indexDocument;
    private final String root;

    public DynamicXmlHttpResource(String stylesheet, String root) throws InitializationException {
        this.stylesheet = stylesheet;
        this.root = root;
        this.toolkit = new XMLToolkit();
        this.indexDocument = this.createIndexDocument();
    }

    private Document createIndexDocument() {
        Document document = this.toolkit.newDocument();
        Element main = document.createElement(this.root);
        document.appendChild(main);
        document.insertBefore(document.createProcessingInstruction("xml-stylesheet", String.format("type=\"text/xsl\" href=\"%s\"", this.stylesheet)), document.getDocumentElement());
        return document;
    }

    @Override
    public void handleIndexEntity(WebserviceResponse response, String requestPath) throws SerializeException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(this.indexDocument);
            StreamResult outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
            ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
            InputStreamEntity entity = new InputStreamEntity((InputStream)is, -1L);
            if (entity != null) {
                entity.setContentType(this.getIndexContentType().getValue());
                response.respondEntity((HttpEntity)entity, 200);
            }
        }
        catch (TransformerConfigurationException exc) {
            logger.warn("Could not get entity: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TransformerException exc) {
            logger.warn("Could not get entity: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TransformerFactoryConfigurationError exc) {
            logger.warn("Could not get entity: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    @Override
    public HttpContentType getIndexContentType() {
        return HttpContentType.XML;
    }

    @Override
    public InputStreamEntity getEntityForResourcePath(String localPath) throws IOException {
        InputStream resourceStream = StaticFileHttpResource.class.getResourceAsStream(localPath);
        if (resourceStream != null) {
            if (FilenameUtils.isExtension((String)localPath.toLowerCase(), (String)"xml")) {
                try {
                    Element root = this.toolkit.getDocumentRootFromInputStream(resourceStream);
                    root.getOwnerDocument().insertBefore(root.getOwnerDocument().createProcessingInstruction("xml-stylesheet", String.format("type=\"text/xsl\" href=\"%s\"", this.stylesheet)), root);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DOMSource xmlSource = new DOMSource(root.getOwnerDocument());
                    StreamResult outputTarget = new StreamResult(outputStream);
                    TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                    ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
                    InputStreamEntity body = new InputStreamEntity((InputStream)is, -1L);
                    body.setContentType(StaticFileHttpRequestHandler.getContentType(localPath).getValue());
                    return body;
                }
                catch (SerializeException exc) {
                    throw new IOException(exc);
                }
                catch (TransformerConfigurationException exc) {
                    throw new IOException(exc);
                }
                catch (TransformerException exc) {
                    throw new IOException(exc);
                }
                catch (TransformerFactoryConfigurationError exc) {
                    throw new IOException(exc);
                }
            }
            InputStreamEntity body = new InputStreamEntity(resourceStream, -1L);
            body.setContentType(StaticFileHttpRequestHandler.getContentType(localPath).getValue());
            return body;
        }
        return null;
    }
}

