/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CustomTrustManager
implements X509TrustManager {
    static ESLLogger logger = ESLLogger.getLogger(CustomTrustManager.class);
    private X509TrustManager defaultTrustManager;

    public CustomTrustManager() throws InitializationException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] tms = trustManagerFactory.getTrustManagers();
            for (int index = 0; index < tms.length; ++index) {
                if (!(tms[index] instanceof X509TrustManager)) continue;
                this.defaultTrustManager = (X509TrustManager)tms[index];
                return;
            }
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
        throw new InitializationException("Couldn't load default trust manager", new Object[0]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException exc) {
            logger.warn("Certificate not trusted (%s)", exc.getMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

