/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.http.BasicHttpRequestHandlerResolver;
import at.mrdevelopment.toolkit.http.RequestListenerThread;
import at.mrdevelopment.toolkit.http.WebserviceException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLServerSocketFactory;

public class BasicHttpServer
implements Shutdownable {
    private final BasicHttpRequestHandlerResolver registry;
    private final List<RequestListenerThread> listenerThreads = new CopyOnWriteArrayList<RequestListenerThread>();

    public BasicHttpServer() {
        this.registry = new BasicHttpRequestHandlerResolver();
    }

    public final void listen(int port, boolean useSSL, int threadPoolSize, SSLServerSocketFactory sslServerSocketFactory, boolean verifyClientCertificates) throws WebserviceException {
        this.listen(port, useSSL, threadPoolSize, sslServerSocketFactory, verifyClientCertificates, null);
    }

    public final void listen(int port, boolean useSSL, int threadPoolSize, SSLServerSocketFactory sslServerSocketFactory, boolean verifyClientCertificates, InetAddress address) throws WebserviceException {
        RequestListenerThread listenerThread = new RequestListenerThread(port, useSSL, this.registry, threadPoolSize, 1, sslServerSocketFactory, verifyClientCertificates, address);
        this.listenerThreads.add(listenerThread);
        listenerThread.start();
    }

    public final void register(BasicHttpRequestHandler handler) {
        this.registry.register(handler);
    }

    public final void registerInFront(BasicHttpRequestHandler handler) {
        this.registry.registerInFront(handler);
    }

    public void unregister(BasicHttpRequestHandler handler) {
        this.registry.unregister(handler);
    }

    @Override
    public final void shutdown() {
        for (RequestListenerThread thread : this.listenerThreads) {
            thread.shutdown();
        }
        this.listenerThreads.clear();
    }

    public BasicHttpRequestHandlerResolver getRegistry() {
        return this.registry;
    }
}

