/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;

public class BasicHttpRequestHandlerResolver
implements HttpRequestHandlerMapper {
    static ESLLogger logger = ESLLogger.getLogger(BasicHttpRequestHandlerResolver.class);
    private final List<BasicHttpRequestHandler> handlers = new ArrayList<BasicHttpRequestHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestHandler lookup(HttpRequest request) {
        try {
            URI requestUri = new URI(request.getRequestLine().getUri());
            List<BasicHttpRequestHandler> list = this.handlers;
            synchronized (list) {
                for (BasicHttpRequestHandler handler : this.handlers) {
                    if (!handler.lookup(requestUri)) continue;
                    return handler;
                }
            }
        }
        catch (URISyntaxException exc) {
            logger.logException(exc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BasicHttpRequestHandler handler) {
        List<BasicHttpRequestHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInFront(BasicHttpRequestHandler handler) {
        List<BasicHttpRequestHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(0, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BasicHttpRequestHandler> getHandlers() {
        List<BasicHttpRequestHandler> list = this.handlers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<BasicHttpRequestHandler>(this.handlers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(BasicHttpRequestHandler handler) {
        List<BasicHttpRequestHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }
}

