/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.Authentication;
import at.mrdevelopment.toolkit.http.BasicAuthUtils;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class BasicAuthentication
implements Authentication {
    static ESLLogger logger = ESLLogger.getLogger(BasicAuthentication.class);
    private final Authenticator authenticator;
    private final String realm;

    public BasicAuthentication(Authenticator authenticator, String realm) {
        this.authenticator = authenticator;
        this.realm = realm;
    }

    @Override
    public UserId authorize(HttpRequest request) {
        Header authorizationHeader = request.getFirstHeader("Authorization");
        if (authorizationHeader == null) {
            logger.info("Missing authorization header");
            return new RequestUser(Role.NONE);
        }
        return BasicAuthUtils.authorize(authorizationHeader.getValue(), this.authenticator);
    }

    @Override
    public void responseUnauthorized(HttpResponse response) {
        try {
            response.setStatusCode(401);
            response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\""));
            StringEntity body = new StringEntity("Unauthorized");
            response.setEntity((HttpEntity)body);
        }
        catch (UnsupportedEncodingException exc) {
            logger.logException(exc);
        }
    }
}

