/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.UsernamePasswordCredentials;

public class BasicAuthUtils {
    static ESLLogger logger = ESLLogger.getLogger(BasicAuthUtils.class);

    public static UsernamePasswordCredentials parseCredentials(String authorizationHeader) {
        if (authorizationHeader == null) {
            logger.info("Missing authorization header");
            return null;
        }
        String value = authorizationHeader;
        String[] parts = StringUtils.split((String)value);
        if (parts.length != 2) {
            logger.warn("Not a valid authentication request (%s)", value);
            return null;
        }
        if (!parts[0].equals("Basic")) {
            logger.warn("Not a basic authentication request (%s)", value);
            return null;
        }
        if (parts[0] == null || parts[1] == null) {
            logger.warn("Malformed basic authentication request (%s)", value);
            return null;
        }
        String decodedAuth = new String(new Base64().decode(parts[1]));
        if ((parts = StringUtils.split((String)decodedAuth, (char)':')).length != 2) {
            logger.warn("Malformed basic authentication request (%s)", value);
            return null;
        }
        String username = parts[0];
        String password = parts[1];
        return new UsernamePasswordCredentials(username, password);
    }

    public static UserId authorize(String username, String password, Authenticator authenticator) {
        UserId user = authenticator.authorize(username, password);
        logger.info("Basic authentication request with username %s, password ***** %s", username, user.isAuthorized() ? "successful" : "failed");
        return user;
    }

    public static UserId authorize(String authorizationHeader, Authenticator authenticator) {
        UsernamePasswordCredentials credentials = BasicAuthUtils.parseCredentials(authorizationHeader);
        if (credentials == null) {
            return new RequestUser(Role.NONE);
        }
        return BasicAuthUtils.authorize(credentials.getUserName(), credentials.getPassword(), authenticator);
    }
}

