/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.help;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractHelpGenerator {
    public static final String HELP_SRC_DIRECTORY = "data/help/src";
    public static final String HELP_DST_DIRECTORY = "../../help/";
    public static final String GENERAL_XML_FILE = "general.xml";
    public static final String INDEX_XML_FILE = "index.xml";
    private final Transformer transformer;
    protected XMLToolkit xmlToolkit;
    protected String destinationFolder;

    public AbstractHelpGenerator(String destinationFolder) throws InitializationException {
        this.destinationFolder = destinationFolder;
        this.xmlToolkit = new XMLToolkit();
        if (new File(destinationFolder).exists()) {
            FileUtils.deleteQuietly((File)new File(destinationFolder));
        }
        try {
            this.createOutputDirectory(HELP_SRC_DIRECTORY, destinationFolder);
            this.transformer = this.createTransformer(new StreamSource(new File(destinationFolder, "reference.xsl")));
            File indexFile = new File(destinationFolder, "index.html");
            this.writeDocument(indexFile, this.createIndexDocument());
            this.transformFile(new File(HELP_SRC_DIRECTORY, GENERAL_XML_FILE), new File(destinationFolder, "general.html"));
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    private Document createIndexDocument() throws SerializeException, InitializationException {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("index");
        Version version = Info.load(AbstractHelpGenerator.class).getVersion();
        root.setAttribute("version", version.getVersionString());
        root.setAttribute("build", String.valueOf(version.getBuild()));
        document.appendChild(root);
        return document;
    }

    public AbstractHelpGenerator() throws InitializationException {
        this(HELP_DST_DIRECTORY);
    }

    public abstract void generate() throws Exception;

    private Transformer createTransformer(Source xsltSource) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void createOutputDirectory(String helpSrcDirectory, String helpDstDirectory) throws IOException {
        File srcDirectory = new File(helpSrcDirectory);
        File dstDirectory = new File(helpDstDirectory);
        FileUtils.copyDirectory((File)srcDirectory, (File)dstDirectory, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)".svn")));
        FileUtils.deleteQuietly((File)new File(this.destinationFolder, GENERAL_XML_FILE));
        FileUtils.deleteQuietly((File)new File(this.destinationFolder, INDEX_XML_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDocument(File destinationFile, Document document) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(destinationFile);
            XMLContentProducer contentProducer = new XMLContentProducer(document, this.transformer, null);
            contentProducer.writeTo(outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformFile(File sourceFile, File targetFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            StreamSource source = new StreamSource(sourceFile);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(source, result);
            }
        }
        catch (TransformerException exc) {
            try {
                throw new IOException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close(outputStream);
    }
}

