/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.wizard;

import at.mrdevelopment.toolkit.gui.wizard.ValidationListener;
import at.mrdevelopment.toolkit.gui.wizard.WizardModel;
import at.mrdevelopment.toolkit.gui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WizardDialog
extends JDialog
implements ValidationListener {
    private JButton previousButton;
    private JButton nextButton;
    private JButton cancelButton;
    private CardLayout cardLayout;
    private JPanel mainPanel;
    private Map<String, Object> data;
    private final WizardModel model;

    public WizardDialog(JFrame owner, String title, WizardModel model) {
        this(owner, title, model, new HashMap<String, Object>(), false);
    }

    public WizardDialog(JFrame owner, String title, WizardModel model, Map<String, Object> data, boolean autoProceedOnStart) {
        super(owner);
        this.model = model;
        this.setModal(true);
        this.setTitle(title);
        this.setLayout(new BorderLayout());
        this.data = data;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WizardDialog.this.onCancelButton();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.previousButton = new JButton("Previous");
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onPreviousButton();
            }
        });
        buttonPanel.add(this.previousButton);
        this.nextButton = new JButton("Next");
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onNextButton();
            }
        });
        buttonPanel.add(this.nextButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onCancelButton();
            }
        });
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, "South");
        this.mainPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.mainPanel.setLayout(this.cardLayout);
        for (WizardPanel panel : model.getPanels()) {
            this.mainPanel.add((Component)panel.getPanel(), panel.getIdentifier());
        }
        this.add((Component)this.mainPanel, "Center");
        this.registerEscapeKeyAction();
        this.getRootPane().setDefaultButton(this.nextButton);
        this.setPreferredSize(new Dimension(600, 600));
        this.pack();
        this.setLocationRelativeTo(owner);
        if (autoProceedOnStart) {
            while (this.onNextButton()) {
            }
        } else {
            this.changeToNextWizard();
        }
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            ((JFrame)this.getParent()).dispose();
        }
    }

    private void changeToNextWizard() {
        this.onNextButton();
    }

    protected void onCancelButton() {
        if (this.model.hasCurrentPanel()) {
            if (this.model.getCurrentPanel().onCancel()) {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    protected boolean onNextButton() {
        if (this.model.hasCurrentPanel() && !this.model.getCurrentPanel().canProceed()) {
            return false;
        }
        if (this.model.hasCurrentPanel()) {
            Map<String, Object> newData = this.model.getCurrentPanel().proceed(this.data);
            if (newData == null) {
                return false;
            }
            this.data.putAll(newData);
        }
        if (this.model.hasNextWizard()) {
            this.cardLayout.show(this.mainPanel, this.model.getNextPanel().getIdentifier());
            this.updateButtons(true, this.model.getCurrentPanel().canProceed(), this.model.hasPreviousWizard() && this.model.getCurrentPanel().canPrevious());
            this.model.getCurrentPanel().wizardWillBeShown(this.data, this, this);
            this.changeProceedButtonText(this.model.hasNextWizard() ? "Next" : "Finish");
        } else {
            this.finishWizard();
        }
        return true;
    }

    private void finishWizard() {
        this.setVisible(false);
    }

    protected void onPreviousButton() {
        if (this.model.hasPreviousWizard() && this.model.getCurrentPanel().canPrevious()) {
            this.data.putAll(this.model.getCurrentPanel().onPrevious(this.data));
            this.cardLayout.show(this.mainPanel, this.model.getPreviousPanel().getIdentifier());
            this.updateButtons(true, this.model.getCurrentPanel().canProceed(), this.model.hasPreviousWizard() && this.model.getCurrentPanel().canPrevious());
            this.changeProceedButtonText(this.model.hasNextWizard() ? "Next" : "Finish");
            this.model.getCurrentPanel().wizardWillBeShown(this.data, this, this);
        }
    }

    public void changeProceedButtonText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardDialog.this.nextButton.setText(text);
                WizardDialog.this.nextButton.requestFocus();
            }
        });
    }

    public void updateButtons(final boolean cancelEnabled, final boolean nextEnabled, final boolean previousEnabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardDialog.this.cancelButton.setEnabled(cancelEnabled);
                WizardDialog.this.nextButton.setEnabled(nextEnabled);
                WizardDialog.this.previousButton.setEnabled(previousEnabled);
            }
        });
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public void validated(final boolean valid) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WizardDialog.this.nextButton.getText().equals("Finish")) {
                    WizardDialog.this.nextButton.setEnabled(true);
                } else {
                    WizardDialog.this.nextButton.setEnabled(valid);
                }
            }
        });
    }

    private void registerEscapeKeyAction() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.onCancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void forceProceed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardDialog.this.onNextButton();
            }
        });
    }

    public void restartDialog() {
        this.model.reset();
        this.changeToNextWizard();
    }

    public void forcePrevious() {
        this.onPreviousButton();
    }
}

