/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.resizeable;

import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class TwoPointBorder
extends CanvasBorder {
    private static final int DEFAULT_RADIUS = 4;
    private boolean isP1;

    @Override
    public void paintBorder(Graphics g, Shape shape, int x, int y, int w, int h, CanvasBorder.BorderStyle borderStyle, int mouseX, int mouseY, int oldX, int oldY) {
        if (borderStyle == CanvasBorder.BorderStyle.FULL_FOCUS) {
            g.setColor(Color.BLACK);
        } else if (borderStyle == CanvasBorder.BorderStyle.SLIGHT_FOCUS) {
            g.setColor(Color.LIGHT_GRAY);
        } else {
            return;
        }
        if (borderStyle == CanvasBorder.BorderStyle.FULL_FOCUS) {
            g.setColor(Color.BLACK);
        } else if (borderStyle == CanvasBorder.BorderStyle.SLIGHT_FOCUS) {
            g.setColor(Color.LIGHT_GRAY);
        }
        if (g instanceof Graphics2D) {
            float[] dash_array = new float[]{10.0f, 5.0f};
            BasicStroke s4 = new BasicStroke(1.0f, 2, 1, 1.0f, dash_array, 0.0f);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(s4);
        }
        if (shape instanceof Line2D) {
            Line2D line = (Line2D)shape;
            g.fillOval((int)line.getX1() - 4, (int)line.getY1() - 4, 8, 8);
            g.fillOval((int)line.getX2() - 4, (int)line.getY2() - 4, 8, 8);
        } else {
            g.fillOval(x - 4, y - 4, 8, 8);
            g.fillOval(x + w - 1 - 4, y + h - 1 - 4, 8, 8);
        }
    }

    @Override
    public int getCursor(Point point, Shape elementShape) {
        Rectangle rect1 = null;
        Rectangle rect2 = null;
        if (elementShape instanceof Line2D) {
            Line2D line = (Line2D)elementShape;
            rect1 = new Rectangle((int)line.getX1() - 4, (int)line.getY1() - 4, 8, 8);
            rect2 = new Rectangle((int)line.getX2() - 4, (int)line.getY2() - 4, 8, 8);
        } else {
            rect1 = new Rectangle(elementShape.getBounds().x - 4, elementShape.getBounds().y - 4, 8, 8);
            rect2 = new Rectangle(elementShape.getBounds().x + elementShape.getBounds().width - 4, elementShape.getBounds().y + elementShape.getBounds().height - 4, 8, 8);
        }
        if (rect1.contains(point)) {
            this.isP1 = true;
            return 1;
        }
        if (rect2.contains(point)) {
            this.isP1 = false;
            return 1;
        }
        return 13;
    }

    public boolean isP1() {
        return this.isP1;
    }
}

