/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.resizeable;

import at.mrdevelopment.toolkit.gui.Canvas;
import at.mrdevelopment.toolkit.gui.CanvasElement;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import at.mrdevelopment.toolkit.gui.resizeable.TwoPointBorder;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class ResizeableCanvasElement
extends CanvasElement {
    private static final int ABSOLUTE_MIN_SIZE = 5;
    private final int imageHeight;
    private final int imageWidth;
    private final int rotation;
    private int mouseX;
    private int mouseY;
    private int oldX;
    private int oldY;

    public ResizeableCanvasElement(Canvas parent, int id, int x, int y, int width, int height, Shape origBounds, int imageHeight, int imageWidth, int rotation, CanvasBorder canvasBorder) {
        super(parent, id, x, y, width, height, origBounds, canvasBorder);
        this.imageHeight = imageHeight;
        this.imageWidth = imageWidth;
        this.rotation = rotation;
    }

    @Override
    public String toString() {
        return "ResizeableCanvasElement [" + super.toString() + "]";
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle bounds = super.getBounds().getBounds();
        CanvasBorder.BorderStyle borderStyle = CanvasBorder.BorderStyle.SHOW_BOUNDS;
        if (this.getParent().getElementFocused() == this.getId()) {
            borderStyle = CanvasBorder.BorderStyle.FULL_FOCUS;
        } else if (this.getParent().getElementSlightlyFocused() == this.getId()) {
            borderStyle = CanvasBorder.BorderStyle.SLIGHT_FOCUS;
        }
        this.getCanvasBorder().paintBorder(graphics, this.getBounds(), bounds.x, bounds.y, bounds.width, bounds.height, borderStyle, this.mouseX, this.mouseY, this.oldX, this.oldY);
    }

    @Override
    public void handleMouseDragged(MouseEvent me, int dx, int dy, int oldX, int oldY, int oldWidth, int oldHeight, Shape shape) {
        ViewState viewState = this.getParent().getViewState();
        int maxX = viewState.getViewX() + this.getParent().getWidth();
        int maxY = viewState.getViewY() + this.getParent().getHeight();
        this.mouseX = me.getX() < 0 ? 0 : me.getX();
        this.mouseY = me.getY() < 0 ? 0 : me.getY();
        this.mouseX = this.mouseX > maxX ? maxX : this.mouseX;
        this.mouseY = this.mouseY > maxY ? maxY : this.mouseY;
        this.oldX = oldX;
        this.oldY = oldY;
        Shape bounds = this.calculateNewBounds(me.isShiftDown(), this.getParent().getPanel().getCursor().getType(), dx, dy, viewState.getViewX(), viewState.getViewY(), maxX, maxY, oldX, oldY, oldWidth, oldHeight, shape);
        Shape newOrigBounds = this.calculateOriginalBounds(bounds);
        this.setOriginalBounds(newOrigBounds);
        this.setBounds(bounds);
    }

    @Override
    public void handleMousePressed(MouseEvent me) {
    }

    @Override
    public void handleMouseClicked(MouseEvent me) {
    }

    @Override
    public void handleMouseReleased(MouseEvent me) {
    }

    public Shape calculateOriginalBounds(Shape shape) {
        ViewState viewState = this.getParent().getViewState();
        if (shape instanceof Line2D) {
            if (this.rotation == 90 || this.rotation == 180 || this.rotation == 270) {
                Line2D line = (Line2D)shape;
                Line2D.Double newLine = new Line2D.Double();
                newLine.setLine(line);
                double dx1 = ((Line2D)newLine).getX1() - newLine.getBounds().getCenterX();
                double dy1 = ((Line2D)newLine).getY1() - newLine.getBounds().getCenterY();
                double newX1 = newLine.getBounds().getCenterX() - dx1 * Math.cos(this.rotation) + dy1 * Math.sin(this.rotation);
                double newY1 = newLine.getBounds().getCenterX() - dx1 * Math.sin(this.rotation) - dy1 * Math.cos(this.rotation);
                double dx2 = ((Line2D)newLine).getX2() - newLine.getBounds().getCenterX();
                double dy2 = ((Line2D)newLine).getY2() - newLine.getBounds().getCenterY();
                double newX2 = newLine.getBounds().getCenterX() - dx2 * Math.cos(this.rotation) + dy2 * Math.sin(this.rotation);
                double newY2 = newLine.getBounds().getCenterX() - dx2 * Math.sin(this.rotation) - dy2 * Math.cos(this.rotation);
                ((Line2D)newLine).setLine(newX1, newY1, newX2, newY2);
                return newLine;
            }
            return shape;
        }
        Rectangle bounds = shape.getBounds();
        Rectangle newBounds = new Rectangle((bounds.x - viewState.getViewX()) / viewState.getScale(), (bounds.y - viewState.getViewY()) / viewState.getScale(), bounds.width / viewState.getScale(), bounds.height / viewState.getScale());
        if (this.rotation == 90 || this.rotation == 180 || this.rotation == 270) {
            for (int index = 0; index < this.rotation; index += 90) {
                int height = 0;
                if (this.rotation == 180) {
                    height = this.imageWidth;
                    if (index == 90) {
                        height = this.imageHeight;
                    }
                } else {
                    height = this.imageHeight;
                    if (index == 90) {
                        height = this.imageWidth;
                    }
                }
                newBounds = this.rotate90Degrees(newBounds, height);
            }
        }
        return newBounds;
    }

    private Rectangle rotate90Degrees(Rectangle bounds, int height) {
        return new Rectangle(bounds.y, height - bounds.width - bounds.x, bounds.height, bounds.width);
    }

    private Shape calculateNewBounds(boolean proportional, int cursorType, int dx, int dy, int minX, int minY, int maxX, int maxY, int x, int y, int w, int h, Shape shape) {
        int by;
        int rx;
        if (cursorType == 13) {
            if (shape instanceof Rectangle) {
                Rectangle bounds = new Rectangle(x, y, w, h);
                bounds.translate(dx, dy);
                bounds.x = Math.max(bounds.x, minX);
                bounds.y = Math.max(bounds.y, minY);
                if (bounds.x + bounds.width > maxX) {
                    bounds.x = maxX - bounds.width;
                }
                if (bounds.y + bounds.height > maxY) {
                    bounds.y = maxY - bounds.height;
                }
                return bounds;
            }
            if (shape instanceof Line2D) {
                Line2D line = (Line2D)shape;
                Line2D.Double newLine = new Line2D.Double();
                newLine.setLine(line);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(dx, dy);
                Point2D[] newPoints = new Point2D[]{new Point2D.Double(), new Point2D.Double()};
                affineTransform.transform(new Point2D[]{((Line2D)newLine).getP1(), ((Line2D)newLine).getP2()}, 0, newPoints, 0, 2);
                for (Point2D point : newPoints) {
                    if (point.getX() < 0.0) {
                        point.setLocation(0.0, point.getY());
                    }
                    if (point.getX() > (double)maxX) {
                        point.setLocation(maxX, point.getY());
                    }
                    if (point.getY() < 0.0) {
                        point.setLocation(point.getX(), 0.0);
                    }
                    if (!(point.getY() > (double)maxY)) continue;
                    point.setLocation(point.getX(), maxY);
                }
                newLine.setLine(newPoints[0], newPoints[1]);
                return newLine;
            }
        }
        if (cursorType == 1) {
            int scaledX = Math.round(this.mouseX * this.getParent().getScale());
            int scaledY = Math.round(this.mouseY * this.getParent().getScale());
            if (this.getBounds() instanceof Line2D) {
                Line2D boundsLine = (Line2D)this.getBounds();
                if (((TwoPointBorder)this.getCanvasBorder()).isP1()) {
                    return new Line2D.Double(scaledX, scaledY, boundsLine.getX2(), boundsLine.getY2());
                }
                return new Line2D.Double(boundsLine.getX1(), boundsLine.getY1(), scaledX, scaledY);
            }
            return new Line2D.Double(x, y, scaledX, scaledY);
        }
        if (proportional) {
            if (cursorType == 5) {
                dx = (int)((float)dy * this.getWidthScale());
            } else if (cursorType == 4) {
                dx = -((int)((float)dy * this.getWidthScale()));
            } else if (cursorType == 7) {
                dy = -((int)((float)dx * this.getHeightScale()));
            } else if (cursorType == 6) {
                dy = (int)((float)dx * this.getHeightScale());
            }
        }
        if ((cursorType == 6 || cursorType == 10 || cursorType == 4) && (w = (rx = x + w) - (x = Math.max(minX, x + dx))) < this.getRelativeMinSize()) {
            w = this.getRelativeMinSize();
            x = Math.max(minX, rx - w);
        }
        if (cursorType == 4 || cursorType == 9 || cursorType == 5) {
            int newH = h + dy;
            if (y + newH > maxY) {
                newH = maxY - y;
            }
            if (newH < this.getRelativeMinSize()) {
                newH = this.getRelativeMinSize();
            }
            h = newH;
        }
        if (cursorType == 5 || cursorType == 11 || cursorType == 7) {
            int newW = w + dx;
            if (x + newW > maxX) {
                newW = maxX - x;
            }
            if (newW < this.getRelativeMinSize()) {
                newW = this.getRelativeMinSize();
            }
            w = newW;
        }
        if ((cursorType == 7 || cursorType == 8 || cursorType == 6) && (h = (by = y + h) - (y = Math.max(minY, y + dy))) < this.getRelativeMinSize()) {
            h = this.getRelativeMinSize();
            y = Math.max(minY, by - h);
        }
        return new Rectangle(x, y, w, h);
    }

    private int getRelativeMinSize() {
        return 5 * this.getParent().getScale();
    }

    @Override
    public int getCursor(int x, int y) {
        return this.getCanvasBorder().getCursor(new Point(x, y), this.getBounds());
    }
}

