/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.resizeable;

import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public class ResizeableBorder
extends CanvasBorder {
    private static final int DEFAULT_DIST = 8;
    private int dist = 8;

    @Override
    public void paintBorder(Graphics g, Shape shape, int x, int y, int w, int h, CanvasBorder.BorderStyle borderStyle, int mouseX, int mouseY, int oldX, int oldY) {
        block9: {
            Rectangle rect;
            block8: {
                if (borderStyle == CanvasBorder.BorderStyle.FULL_FOCUS) {
                    g.setColor(Color.BLACK);
                } else if (borderStyle == CanvasBorder.BorderStyle.SLIGHT_FOCUS) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    return;
                }
                if (g instanceof Graphics2D) {
                    float[] dash_array = new float[]{10.0f, 5.0f};
                    BasicStroke s4 = new BasicStroke(1.0f, 2, 1, 1.0f, dash_array, 0.0f);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setStroke(s4);
                    g.drawRect(x, y, w - 1, h - 1);
                    g2d.setStroke(new BasicStroke());
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
                if (borderStyle != CanvasBorder.BorderStyle.FULL_FOCUS) break block8;
                for (int i = 0; i < this.locations.length; ++i) {
                    rect = this.getRectangle(x, y, w, h, this.locations[i]);
                    g.setColor(Color.WHITE);
                    g.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    g.setColor(Color.BLACK);
                    g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                }
                break block9;
            }
            if (borderStyle != CanvasBorder.BorderStyle.SLIGHT_FOCUS) break block9;
            for (int i = 0; i < this.locations.length; ++i) {
                rect = this.getRectangle(x, y, w, h, this.locations[i]);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        }
    }

    private Rectangle getRectangle(int x, int y, int width, int height, int location) {
        switch (location) {
            case 1: {
                return new Rectangle(x + width / 2 - this.dist / 2, y, this.dist, this.dist);
            }
            case 5: {
                return new Rectangle(x + width / 2 - this.dist / 2, y + height - this.dist, this.dist, this.dist);
            }
            case 7: {
                return new Rectangle(x, y + height / 2 - this.dist / 2, this.dist, this.dist);
            }
            case 3: {
                return new Rectangle(x + width - this.dist, y + height / 2 - this.dist / 2, this.dist, this.dist);
            }
            case 8: {
                return new Rectangle(x, y, this.dist, this.dist);
            }
            case 2: {
                return new Rectangle(x + width - this.dist, y, this.dist, this.dist);
            }
            case 6: {
                return new Rectangle(x, y + height - this.dist, this.dist, this.dist);
            }
            case 4: {
                return new Rectangle(x + width - this.dist, y + height - this.dist, this.dist, this.dist);
            }
        }
        return null;
    }

    @Override
    public int getCursor(Point point, Shape elementShape) {
        int x = elementShape.getBounds().x;
        int y = elementShape.getBounds().y;
        int width = elementShape.getBounds().width;
        int height = elementShape.getBounds().height;
        for (int i = 0; i < this.locations.length; ++i) {
            Rectangle rect = this.getRectangle(x, y, width, height, this.locations[i]);
            if (!rect.contains(point)) continue;
            return this.cursors[i];
        }
        return 13;
    }
}

