/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import at.mrdevelopment.toolkit.gui.options.TransparentColorChooserPanel;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.converter.ColorStringConverter;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorTableCell
extends AbstractCellEditor
implements TableCellEditor {
    static ESLLogger logger = ESLLogger.getLogger(ColorTableCell.class);
    private final ColorStringConverter colorStringConverter;
    private DisplayableOption option;
    private JPanel panel;
    private int row;
    private JTable table;
    private JLabel label;
    private JLabel colorLabel;
    private EventDispatcher eventDispatcher;
    private ViewState viewState;
    private boolean aborted = false;

    public ColorTableCell(DisplayableOption option, EventDispatcher eventDispatcher, ViewState viewState) {
        Paint color;
        this.option = option;
        this.eventDispatcher = eventDispatcher;
        this.viewState = viewState;
        this.colorStringConverter = new ColorStringConverter();
        try {
            color = this.colorStringConverter.reconvert(option.getValue());
        }
        catch (ConversionException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            color = Color.black;
        }
        this.panel = new JPanel(new BorderLayout());
        this.label = new JLabel(option.getValue());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.colorLabel = new JLabel();
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(Color.WHITE);
        this.colorLabel.setIcon(this.createImageIcon(12, 12, color));
        JButton button = new JButton("...");
        button.setMargin(new Insets(1, 1, 1, 1));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableCell.this.onShowColorDialog();
            }
        });
        this.panel.add((Component)this.colorLabel, "West");
        this.panel.add((Component)this.label, "Center");
        this.panel.add((Component)button, "East");
    }

    protected void onShowColorDialog() {
        Paint color;
        try {
            color = this.colorStringConverter.reconvert(this.option.getValue());
        }
        catch (ConversionException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            color = Color.black;
        }
        if (color instanceof Color) {
            JColorChooser pane = new JColorChooser((Color)color);
            pane.addChooserPanel(new TransparentColorChooserPanel());
            ColorTracker ok = new ColorTracker(pane);
            this.aborted = false;
            JDialog dialog = JColorChooser.createDialog(this.table, "Choose color..", true, pane, ok, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorTableCell.this.aborted = true;
                }
            });
            dialog.setVisible(true);
            Color selectedColor = ok.getColor();
            if (!this.aborted && color != null) {
                this.label.setText(this.colorStringConverter.convert(selectedColor));
                this.colorLabel.setIcon(this.createImageIcon(12, 12, selectedColor));
                OptionsTableEntry optionEntry = (OptionsTableEntry)this.table.getModel().getValueAt(this.row, 1);
                OptionChangeEvent oce = new OptionChangeEvent(optionEntry.getPath(), this.viewState.getElementFocused(), this.label.getText());
                this.eventDispatcher.dispatchEvent(oce);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.option.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        return this.panel;
    }

    private ImageIcon createImageIcon(int width, int height, Paint color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(Color.black);
        graphics.drawRect(0, 0, width, height);
        graphics.setPaint(color);
        graphics.fillRect(1, 1, width - 2, height - 2);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public JPanel getPanel(JTable table, int row) {
        this.table = table;
        this.row = row;
        return this.panel;
    }

    class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color = null;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

