/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class ButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JPanel buttonPanel;
    private List<JToggleButton> buttons;
    private JTable table;
    private int row;
    private int height = 0;

    public ButtonEditor(final EventDispatcher eventDispatcher, final int fieldId, DisplayableOption option, Map<String, ImageIcon> iconMapping) {
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent paramChangeEvent) {
                OptionsTableEntry optionEntry = (OptionsTableEntry)ButtonEditor.this.table.getModel().getValueAt(ButtonEditor.this.row, 1);
                OptionChangeEvent oce = new OptionChangeEvent(optionEntry.getPath(), fieldId, ButtonEditor.this.getValue());
                eventDispatcher.dispatchEvent(oce);
            }

            @Override
            public void editingCanceled(ChangeEvent paramChangeEvent) {
            }
        });
        this.buttonPanel = this.createButtonPanel(iconMapping, option.getValue());
    }

    private JPanel createButtonPanel(Map<String, ImageIcon> iconMapping, String value) {
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setBackground(Color.WHITE);
        panel.add((Component)toolBar, "First");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setLayout(new FlowLayout(0, 0, 0));
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        ButtonGroup group = new ButtonGroup();
        this.buttons = new ArrayList<JToggleButton>();
        for (Map.Entry<String, ImageIcon> entry : iconMapping.entrySet()) {
            JToggleButton button = new JToggleButton(entry.getValue(), entry.getKey().toLowerCase().equals(value));
            this.height = Math.max(this.height, entry.getValue().getIconHeight() + 10);
            button.setFocusable(false);
            button.setName(entry.getKey());
            button.setMargin(new Insets(0, 0, 0, 0));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
            this.buttons.add(button);
            group.add(button);
            toolBar.add(button);
        }
        panel.validate();
        return panel;
    }

    protected String getValue() {
        for (JToggleButton button : this.buttons) {
            if (!button.isSelected()) continue;
            return button.getName();
        }
        return null;
    }

    private void updateValue() {
        if (this.table != null) {
            OptionsTableEntry optionEntry = (OptionsTableEntry)this.table.getModel().getValueAt(this.row, 1);
            String value = optionEntry.getDisplayableOption().getValue();
            for (JToggleButton button : this.buttons) {
                if (button.getName().equals(value)) {
                    button.setSelected(true);
                    continue;
                }
                button.setSelected(false);
            }
        }
    }

    public JPanel getPanel(JTable table, int row) {
        this.table = table;
        if (this.height <= 0 || table.getRowHeight(row) != this.height) {
            // empty if block
        }
        this.row = row;
        this.updateValue();
        return this.buttonPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getPanel(table, row);
    }
}

