/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.gui.ViewUpdateListener;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class ViewArea
implements ViewUpdateListener {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final boolean allowActivation;

    public ViewArea(boolean allowActivation) {
        this.tabbedPane.setFocusable(false);
        this.allowActivation = allowActivation;
    }

    public Component getComponent() {
        return this.tabbedPane;
    }

    public void addView(View view) {
        this.tabbedPane.addTab(view.getTitle(), view.getComponent());
        this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(view.getComponent()), new JLabel(view.getTitle()));
        view.addViewUpdateListener(this);
    }

    public void removeView(View view) {
        view.removeViewUpdateListener(this);
        this.tabbedPane.remove(view.getComponent());
    }

    @Override
    public void viewUpdated(View view) {
        JLabel label = (JLabel)this.tabbedPane.getTabComponentAt(this.tabbedPane.indexOfComponent(view.getComponent()));
        label.setText(view.getTitle());
    }

    @Override
    public void viewCleared(View view) {
    }

    @Override
    public void viewActivated(View view) {
        if (this.allowActivation) {
            this.tabbedPane.setSelectedComponent(view.getComponent());
        }
    }

    public Component getActivatedComponent() {
        return this.tabbedPane.getSelectedComponent();
    }

    public void setViewEnabled(View view, boolean enabled) {
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(view.getComponent()), enabled);
    }
}

