/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.Pair;
import at.mrdevelopment.toolkit.SystemInfo;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SystemInfoDialog {
    public SystemInfoDialog(JFrame parentFrame, String applicationName, Version version) {
        final JDialog dialog = new JDialog(parentFrame, "System Info", true);
        dialog.setLayout(new BorderLayout());
        dialog.setDefaultCloseOperation(2);
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        };
        final SystemInfoTableModel model = new SystemInfoTableModel(applicationName, version);
        JTable table = new JTable(model);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 116) {
                    model.reload();
                }
            }
        });
        JButton okButton = new JButton("OK");
        okButton.setFocusable(false);
        okButton.addActionListener(closeListener);
        GUIUtils.addEscapeListener(dialog, closeListener);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(okButton);
        dialog.add((Component)new JScrollPane(table), "Center");
        dialog.add((Component)buttonPanel, "South");
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.setMinimumSize(new Dimension(100, 100));
        dialog.setPreferredSize(new Dimension(400, 350));
        dialog.pack();
        dialog.setLocationRelativeTo(parentFrame);
        dialog.setVisible(true);
    }

    private static class SystemInfoTableModel
    extends AbstractTableModel {
        private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
        private final String applicationName;
        private final Version version;

        public SystemInfoTableModel(String applicationName, Version version) {
            this.applicationName = applicationName;
            this.version = version;
            this.reload();
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.values.get(rowIndex).getFirst() : this.values.get(rowIndex).getSecond();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Name" : "Value";
        }

        public void reload() {
            this.values.clear();
            SystemInfo systemInfo = new SystemInfo();
            this.values.add(new Pair<String, String>("Application Name", this.applicationName));
            this.values.add(new Pair<String, String>("Application Version", String.format("%s (Build %d)", this.version, this.version.getBuild())));
            this.values.add(new Pair<String, String>("Java Runtime", systemInfo.getJavaRuntimeName()));
            this.values.add(new Pair<String, String>("Java Version", systemInfo.getJavaRuntimeVersion()));
            this.values.add(new Pair<String, String>("Java Virtual Machine", systemInfo.getJavaVmName()));
            this.values.add(new Pair<String, String>("Java Home", systemInfo.getJavaHome()));
            this.values.add(new Pair<String, String>("Operating System", String.format("%s (Version %s, %s)", systemInfo.getOsName(), systemInfo.getOsVersion(), systemInfo.getOsArch())));
            this.values.add(new Pair<String, Integer>("Processors", systemInfo.getAvailableProcessors()));
            this.values.add(new Pair<String, Integer>("Threads", systemInfo.getActiveThreads()));
            this.values.add(new Pair<String, String>("JVM Used Memory", systemInfo.getUsedMemory()));
            this.values.add(new Pair<String, String>("JVM Total Memory", systemInfo.getTotalMemory()));
            this.values.add(new Pair<String, String>("JVM Free Memory", systemInfo.getFreeMemory()));
            this.values.add(new Pair<String, String>("JVM Max Memory", systemInfo.getMaxMemory()));
            this.values.add(new Pair<String, String>("JVM Uptime", systemInfo.getUptime()));
            this.fireTableRowsUpdated(0, this.values.size() - 1);
        }
    }
}

