/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.ProblemListModel;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.Problem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProblemsView
extends AbstractView
implements View {
    static ESLLogger logger = ESLLogger.getLogger(ProblemsView.class);
    private final JPanel panel;
    private final ProblemListModel model = new ProblemListModel();
    private final JList list = new JList(this.model);

    public ProblemsView(MouseListener mouseListener) {
        this();
        this.list.addMouseListener(mouseListener);
    }

    public ProblemsView() {
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new LabelRenderer());
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(200, 30));
        this.panel.add(new JScrollPane(this.list, 22, 30));
    }

    public void update(Collection<Problem> problems) {
        this.model.setProblems(problems);
        this.notifyUpdated();
    }

    public JList getList() {
        return this.list;
    }

    public ProblemListModel getModel() {
        return this.model;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        int count = this.model.getNonInfoProblemsCount();
        return count == 0 ? "Problems" : String.format("Problems (%d)", count);
    }

    private static class LabelRenderer
    extends DefaultListCellRenderer {
        private LabelRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Problem problem = (Problem)value;
            this.setText(problem.getMessage());
            this.setIcon(IconUtils.loadImageIcon(problem.getSeverity().toString().toLowerCase()));
            return this;
        }
    }
}

