/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class MissingIcon
implements Icon {
    private int width;
    private int height;
    private BasicStroke stroke;

    public MissingIcon(int width, int height) {
        this.width = width;
        this.height = height;
        this.stroke = new BasicStroke(Math.max(2, width / 8));
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        Graphics2D graphics2d = (Graphics2D)graphics.create();
        this.paint(graphics2d, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Image toImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics2d = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2d, 0, 0);
        return bufferedImage;
    }

    private void paint(Graphics2D graphics2d, int x, int y) {
        graphics2d.setColor(Color.WHITE);
        graphics2d.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
        graphics2d.setColor(Color.BLACK);
        graphics2d.drawRect(x + 1, y + 1, this.width - 2, this.height - 2);
        graphics2d.setColor(Color.RED);
        graphics2d.setStroke(this.stroke);
        graphics2d.drawLine(x + 10, y + 10, x + this.width - 10, y + this.height - 10);
        graphics2d.drawLine(x + 10, y + this.height - 10, x + this.width - 10, y + 10);
        graphics2d.dispose();
    }
}

