/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.SpringUtilities;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public abstract class LoginWindow {
    static ESLLogger logger = ESLLogger.getLogger(LoginWindow.class);
    private JFrame frame;
    private JTextField usernameField;
    private JPasswordField passwordField;

    protected void initFrame(String presetUsername, String presetPassword, String title, List<? extends Image> icons) {
        this.frame = new JFrame();
        this.frame.setIconImages(icons);
        this.frame.setLayout(new BorderLayout());
        this.frame.setTitle(title);
        this.frame.setResizable(false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent event) {
                LoginWindow.this.passwordField.selectAll();
                LoginWindow.this.passwordField.requestFocusInWindow();
            }

            @Override
            public void windowClosing(WindowEvent event) {
                LoginWindow.this.cancel();
            }
        });
        JPanel loginFormPanel = new JPanel(new SpringLayout());
        loginFormPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder("Login")));
        this.usernameField = new JTextField(presetUsername, 20);
        this.passwordField = new JPasswordField(presetPassword != null ? presetPassword : "", 20);
        loginFormPanel.add(new JLabel("Username:", 11));
        loginFormPanel.add(this.usernameField);
        loginFormPanel.add(new JLabel("Password:", 11));
        loginFormPanel.add(this.passwordField);
        SpringUtilities.makeCompactGrid(loginFormPanel, 2, 2, 8, 2, 4, 4);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton loginButton = new JButton("Login");
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginWindow.this.onLoginButton();
            }
        });
        buttonPanel.add(loginButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginWindow.this.onCancelButton();
            }
        });
        buttonPanel.add(cancelButton);
        this.frame.add((Component)loginFormPanel, "Center");
        this.frame.add((Component)buttonPanel, "South");
        this.frame.setMinimumSize(new Dimension(325, 140));
        this.frame.getRootPane().setDefaultButton(loginButton);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        if (presetPassword != null) {
            this.loginAttempt();
        } else {
            this.frame.setVisible(true);
        }
    }

    public abstract boolean verifyCredentials(String var1, String var2) throws Exception;

    public abstract void login(String var1, String var2) throws Exception;

    public abstract void cancel();

    public abstract void failed(Exception var1);

    private void onLoginButton() {
        this.loginAttempt();
    }

    private void onCancelButton() {
        this.frame.dispose();
        this.cancel();
    }

    private void loginAttempt() {
        try {
            String username = this.usernameField.getText();
            String password = new String(this.passwordField.getPassword());
            this.frame.setVisible(false);
            if (this.verifyCredentials(username, password)) {
                this.frame.dispose();
                this.login(username, password);
            } else {
                this.frame.setVisible(true);
            }
        }
        catch (Exception exc) {
            logger.logException(exc);
            this.failed(exc);
        }
    }
}

