/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.InternalFrameUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class InternalFramesManager
implements InternalFrameListener {
    static ESLLogger logger = ESLLogger.getLogger(InternalFramesManager.class);
    private final JDesktopPane desktop;
    private final JMenu windowMenu;
    private final JMenuItem closeAllItem;
    private final Map<JInternalFrame, OpenFramesEntry> openFrames = new HashMap<JInternalFrame, OpenFramesEntry>();
    private final Deque<JInternalFrame> lastActiveFrames = new LinkedList<JInternalFrame>();

    public InternalFramesManager(JDesktopPane desktop) {
        this.desktop = desktop;
        this.windowMenu = new JMenu("Window");
        this.closeAllItem = new JMenuItem("Close all");
        this.closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InternalFramesManager.this.closeAllFrames();
            }
        });
        this.updateMenu();
    }

    public JMenu getMenu() {
        return this.windowMenu;
    }

    public void addFrame(JInternalFrame frame, boolean centered, int layer) {
        if (centered) {
            InternalFrameUtils.centerFrame(frame, this.desktop);
        } else {
            InternalFrameUtils.placeFrame(frame, this.desktop);
        }
        this.addFrameIntern(frame, layer);
    }

    public void addFrame(JInternalFrame frame, int layer) {
        this.addFrame(frame, false, layer);
    }

    public void addFrame(JInternalFrame frame) {
        this.addFrame(frame, false, 1);
    }

    public void addFrameCentered(JInternalFrame frame, int layer) {
        this.addFrame(frame, true, layer);
    }

    public void addFrameCentered(JInternalFrame frame) {
        this.addFrame(frame, true, 1);
    }

    private void addFrameIntern(final JInternalFrame frame, final int layer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalFramesManager.this.openFrames.put(frame, new OpenFramesEntry(frame.getTitle(), layer == 1));
                InternalFramesManager.this.desktop.add((Component)frame, (Object)layer);
                frame.addInternalFrameListener(InternalFramesManager.this);
                frame.setVisible(true);
                InternalFramesManager.this.updateMenu();
            }
        });
    }

    private void updateMenu() {
        Collection<JMenuItem> menuItems = this.getMenuItems();
        this.windowMenu.removeAll();
        for (JMenuItem menuItem : menuItems) {
            this.windowMenu.add(menuItem);
        }
        if (menuItems.size() > 0) {
            this.windowMenu.addSeparator();
        }
        this.closeAllItem.setEnabled(this.openFrames.size() > 0);
        this.windowMenu.add(this.closeAllItem);
    }

    private Collection<JMenuItem> getMenuItems() {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        if (this.openFrames.size() <= 10) {
            for (Map.Entry<JInternalFrame, OpenFramesEntry> entry : this.openFrames.entrySet()) {
                final JInternalFrame frame = entry.getKey();
                OpenFramesEntry openFramesEntry = entry.getValue();
                if (!openFramesEntry.isVisible()) continue;
                JMenuItem menuItem = new JMenuItem(openFramesEntry.getTitle());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        InternalFrameUtils.toFront(frame);
                    }
                });
                menuItems.add(menuItem);
            }
        }
        Collections.sort(menuItems, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem left, JMenuItem right) {
                return left.getText().compareTo(right.getText());
            }
        });
        return menuItems;
    }

    private void closeAllFrames() {
        Iterator<JInternalFrame> iterator = this.openFrames.keySet().iterator();
        while (iterator.hasNext()) {
            JInternalFrame internalFrame = iterator.next();
            iterator.remove();
            internalFrame.dispose();
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent event) {
        JInternalFrame frame = event.getInternalFrame();
        frame.removeInternalFrameListener(this);
        this.openFrames.remove(frame);
        this.desktop.remove(frame);
        this.updateMenu();
        this.lastActiveFrames.remove(frame);
        this.activateLastActiveFrame();
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent event) {
        JInternalFrame frame = event.getInternalFrame();
        this.lastActiveFrames.remove(frame);
        this.lastActiveFrames.addLast(frame);
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent event) {
    }

    private void activateLastActiveFrame() {
        try {
            if (!this.lastActiveFrames.isEmpty()) {
                JInternalFrame lastFrame = this.lastActiveFrames.getLast();
                lastFrame.setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static class OpenFramesEntry {
        private final String title;
        private final boolean visible;

        public OpenFramesEntry(String title, boolean visible) {
            this.title = title;
            this.visible = visible;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

