/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InternalFrameUtils {
    private static final int PLACE_OFFSET = 22;
    private static final int MAX_PLACE_OFFSET = 100;

    public static void centerFrame(JInternalFrame frame, JDesktopPane desktop) {
        frame.setLocation(Math.max(0, (desktop.getWidth() - frame.getWidth()) / 2), Math.max(0, (desktop.getHeight() - frame.getHeight()) / 2));
    }

    public static void placeFrame(JInternalFrame frame, JDesktopPane desktop) {
        JInternalFrame selectedFrame = desktop.getSelectedFrame();
        if (selectedFrame == null || selectedFrame.getX() > 100 || selectedFrame.getY() > 100) {
            frame.setLocation(0, 0);
        } else {
            int x = Math.max(0, selectedFrame.getX() + 22);
            int y = Math.max(0, selectedFrame.getY() + 22);
            frame.setLocation(x, y);
        }
    }

    public static void showModal(JInternalFrame internalFrame, final JDesktopPane desktop) {
        final Component originalGlassPane = desktop.getRootPane().getGlassPane();
        final PrintGlassPane glass = new PrintGlassPane();
        ((JComponent)glass).setVisible(false);
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent event) {
                glass.setVisible(false);
                desktop.getRootPane().setGlassPane(originalGlassPane);
            }
        });
        glass.add(internalFrame);
        desktop.getRootPane().setGlassPane(glass);
        ((JComponent)glass).setVisible(true);
        internalFrame.setVisible(true);
        try {
            internalFrame.setSelected(true);
        }
        catch (PropertyVetoException ignore) {
            // empty catch block
        }
    }

    public static void toFront(JInternalFrame frame) {
        frame.moveToFront();
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    static class TextureFactory {
        private static final Color DEFAULT_COLOR = new Color(100, 100, 100, 100);

        TextureFactory() {
        }

        public static TexturePaint createCheckerTexture(int cs, Color color) {
            int size = cs * cs;
            BufferedImage img = new BufferedImage(size, size, 6);
            Graphics2D g2 = img.createGraphics();
            g2.setPaint(color);
            g2.fillRect(0, 0, size, size);
            int i = 0;
            while (i * cs < size) {
                int j = 0;
                while (j * cs < size) {
                    if ((i + j) % 2 == 0) {
                        g2.fillRect(i * cs, j * cs, cs, cs);
                    }
                    ++j;
                }
                ++i;
            }
            g2.dispose();
            return new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, size, size));
        }

        public static TexturePaint createCheckerTexture(int cs) {
            return TextureFactory.createCheckerTexture(cs, DEFAULT_COLOR);
        }
    }

    static class PrintGlassPane
    extends JPanel {
        private TexturePaint texture = TextureFactory.createCheckerTexture(4);

        public PrintGlassPane() {
            super(null);
        }

        @Override
        public void setVisible(boolean isVisible) {
            boolean oldVisible = this.isVisible();
            super.setVisible(isVisible);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            if (rootPane != null && this.isVisible() != oldVisible) {
                rootPane.getLayeredPane().setVisible(!isVisible);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            if (rootPane != null) {
                rootPane.getLayeredPane().print(graphics);
            }
            Graphics2D graphics2d = (Graphics2D)graphics;
            graphics2d.setPaint(this.texture);
            graphics2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

