/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.MissingIcon;
import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtils {
    private static final String ICON_PATH = "/icons/";
    private static final String ICON_EXTENSION = ".png";

    public static Icon loadIcon(Class<?> classForIcon) {
        return IconUtils.loadIcon(classForIcon.getSimpleName());
    }

    public static Icon loadIcon(String name) {
        return IconUtils.loadIcon(IconUtils.getIconRessource(name));
    }

    public static ImageIcon loadImageIcon(String name) {
        return IconUtils.loadImageIcon(IconUtils.getIconRessource(name));
    }

    public static BufferedImage loadImage(String name) {
        try {
            return ImageIO.read(IconUtils.getIconRessource(name));
        }
        catch (IOException exc) {
            ImageIcon imageIcon = IconUtils.loadImageIcon(name);
            BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
            Graphics2D g = image.createGraphics();
            imageIcon.paintIcon(null, g, 0, 0);
            g.dispose();
            return image;
        }
    }

    private static URL getIconRessource(String name) {
        return IconUtils.class.getResource(ICON_PATH + name + ICON_EXTENSION);
    }

    private static Icon loadIcon(URL ressource) {
        return ressource != null ? new ImageIcon(ressource) : new MissingIcon(16, 16);
    }

    private static ImageIcon loadImageIcon(URL ressource) {
        return ressource != null ? new ImageIcon(ressource) : new ImageIcon(new MissingIcon(16, 16).toImage());
    }

    public static boolean isIconAvailable(String name) {
        return IconUtils.getIconRessource(name) != null;
    }

    public static Image loadIcon(String applicationName, String imageTemplate) {
        String initials = "";
        char[] charArray = applicationName.toCharArray();
        for (int index = 0; index < charArray.length; ++index) {
            if (!Character.isUpperCase(charArray[index])) continue;
            initials = initials + charArray[index];
        }
        initials = initials.toLowerCase();
        BufferedImage image = IconUtils.loadImage(imageTemplate);
        int multiplicator = 1;
        if (image.getWidth() == 64) {
            multiplicator = 2;
        } else if (image.getWidth() == 128) {
            multiplicator = 4;
        }
        Font font1 = new Font("Arial", 1, 16 * multiplicator);
        Font font2 = new Font("Arial", 1, 9 * multiplicator);
        if (initials.endsWith("gui")) {
            image = ImageUtils.drawIconText(image, initials.substring(0, initials.length() - 3), "gui", font1, font2, Color.black, multiplicator);
        } else {
            initials = initials.length() > 3 ? initials.substring(0, 1) + initials.substring(initials.length() - 2, initials.length()) : initials.substring(0, initials.length());
            image = ImageUtils.drawCenteredText(image, initials, font1, Color.black);
        }
        return image;
    }

    public static List<? extends Image> loadApplicationIcons(String applicationName) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(IconUtils.loadIcon(applicationName, "icon_template_32"));
        images.add(IconUtils.loadIcon(applicationName, "icon_template_64"));
        images.add(IconUtils.loadIcon(applicationName, "icon_template_128"));
        return images;
    }
}

