/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.Canvas;
import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;

public abstract class CanvasElement {
    private static final int DEFAULT_MAX_LINE_DST = 2;
    private int id;
    private Canvas parent;
    private Shape shape;
    private Shape origShape;
    private float widthScale;
    private float heightScale;
    private CanvasBorder canvasBorder;

    public CanvasElement(Canvas parent, int id, int x, int y, int width, int height, Shape origShape, CanvasBorder canvasBorder) {
        this.parent = parent;
        this.id = id;
        this.origShape = origShape;
        this.canvasBorder = canvasBorder;
        this.widthScale = height == 0 ? 1.0f : (float)width / (float)height;
        float f = this.heightScale = width == 0 ? 1.0f : (float)height / (float)width;
        if (origShape instanceof Rectangle) {
            this.shape = new Rectangle(origShape.getBounds());
        } else if (origShape instanceof Line2D) {
            Line2D line2d = (Line2D)origShape;
            this.shape = new Line2D.Double(line2d.getX1(), line2d.getY1(), line2d.getX2(), line2d.getY2());
        }
    }

    public CanvasBorder getCanvasBorder() {
        return this.canvasBorder;
    }

    public float getWidthScale() {
        return this.widthScale;
    }

    public void setWidthScale(float widthScale) {
        this.widthScale = widthScale;
    }

    public float getHeightScale() {
        return this.heightScale;
    }

    public void setHeightScale(float heightScale) {
        this.heightScale = heightScale;
    }

    public int getId() {
        return this.id;
    }

    public Shape getOriginalBounds() {
        return this.origShape;
    }

    public Shape getBounds() {
        return this.shape;
    }

    public void setBounds(Shape bounds) {
        this.shape = bounds;
    }

    public void setOriginalBounds(Shape bounds) {
        this.origShape = bounds;
    }

    public Canvas getParent() {
        return this.parent;
    }

    public boolean containsPoint(int x, int y) {
        if (this.shape instanceof Line2D) {
            Line2D line = (Line2D)this.shape;
            return line.ptLineDist(x, y) <= 2.0;
        }
        return this.shape.contains(x, y);
    }

    public String toString() {
        return "CanvasElement [id=" + this.id + ", parent=" + this.parent + ", bounds=" + this.shape + "]";
    }

    public abstract void paint(Graphics var1);

    public abstract void handleMouseDragged(MouseEvent var1, int var2, int var3, int var4, int var5, int var6, int var7, Shape var8);

    public abstract void handleMousePressed(MouseEvent var1);

    public abstract void handleMouseClicked(MouseEvent var1);

    public abstract void handleMouseReleased(MouseEvent var1);

    public abstract int getCursor(int var1, int var2);
}

