/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.CanvasElement;
import at.mrdevelopment.toolkit.gui.CanvasPanel;
import at.mrdevelopment.toolkit.gui.InsertionMode;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.event.CanvasFocusEvent;
import at.mrdevelopment.toolkit.gui.event.ElementDoubleClickEvent;
import at.mrdevelopment.toolkit.gui.event.ElementFocusChangedEvent;
import at.mrdevelopment.toolkit.gui.event.Event;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.FinishedInsertingElementEvent;
import at.mrdevelopment.toolkit.gui.event.FinishedResizingEvent;
import at.mrdevelopment.toolkit.gui.event.MoveDirection;
import at.mrdevelopment.toolkit.gui.event.MoveElementEvent;
import at.mrdevelopment.toolkit.gui.event.RefreshViewEvent;
import at.mrdevelopment.toolkit.gui.event.RemoveCanvasElementEvent;
import at.mrdevelopment.toolkit.gui.event.ResizeElementEvent;
import at.mrdevelopment.toolkit.gui.event.StartingToResizeEvent;
import at.mrdevelopment.toolkit.gui.event.TranslateViewportEvent;
import at.mrdevelopment.toolkit.gui.resizeable.InsertingCanvasElement;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;

public abstract class Canvas
extends AbstractView
implements View {
    private static int DEFAULT_BOUNDS_WIDTH;
    private static int DEFAULT_BOUNDS_HEIGHT;
    protected EventDispatcher eventDispatcher;
    private JFrame parentFrame;
    private CanvasPanel panel;
    private Map<Integer, CanvasElement> canvasElements;
    private LinkedList<Integer> elementOrder;
    private ViewState viewState = new ViewState();
    private DelayedEventDispatcher delayedDispatcher;
    private int cursorType = Cursor.getDefaultCursor().getType();
    protected int rotation = 0;
    protected int imageHeight = 0;
    protected int imageWidth = 0;
    private InsertionMode insertionMode = InsertionMode.DEACTIVATED;
    private CanvasElement insertingElement = null;
    private Point dragStart;
    private Shape elementBoundsAtDragStart;
    private int elementBeingDragged = -1;

    public Canvas(EventDispatcher eventDispatcher, JFrame parentFrame) {
        this.canvasElements = new HashMap<Integer, CanvasElement>();
        this.elementOrder = new LinkedList();
        this.panel = new CanvasPanel(this);
        this.eventDispatcher = eventDispatcher;
        this.parentFrame = parentFrame;
        CanvasMouseListener canvasMouseListener = new CanvasMouseListener();
        this.getPanel().addMouseWheelListener(canvasMouseListener);
        this.getPanel().addMouseListener(canvasMouseListener);
        this.getPanel().addMouseMotionListener(canvasMouseListener);
        CanvasKeyboardListener canvasKeyboardListener = new CanvasKeyboardListener();
        this.getPanel().addKeyListener(canvasKeyboardListener);
    }

    public int getScale() {
        return this.viewState.getScale();
    }

    public int getElementFocused() {
        return this.viewState.getElementFocused();
    }

    public int getElementSlightlyFocused() {
        return this.viewState.getElementSlightlyFocused();
    }

    public CanvasElement getElementWithId(int id) {
        return this.canvasElements.get(id);
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void addCanvasElement(CanvasElement canvasElement) {
        if (!this.elementOrder.contains(canvasElement.getId())) {
            this.elementOrder.addFirst(canvasElement.getId());
        }
        this.canvasElements.put(canvasElement.getId(), canvasElement);
    }

    public CanvasPanel getPanel() {
        return this.panel;
    }

    public void activateRectangleInsertMode() {
        this.insertionMode = InsertionMode.RECTANGLE;
    }

    public void activateTwoPointInsertMode() {
        this.insertionMode = InsertionMode.TWO_POINT;
    }

    public void cancelInsertMode() {
        this.insertionMode = InsertionMode.DEACTIVATED;
        this.insertingElement = null;
        this.elementBeingDragged = -1;
        this.dragStart = null;
        this.elementBoundsAtDragStart = null;
    }

    protected void bringToFront(int id) {
        boolean found = false;
        int index = 0;
        for (Integer currentId : this.elementOrder) {
            if (currentId == id) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            this.elementOrder.remove(index);
            this.elementOrder.addFirst(id);
        }
    }

    protected int getOrderOfElement(int id) {
        int orderOfElement = 0;
        int index = 0;
        for (Integer currentId : this.elementOrder) {
            if (currentId == id) {
                orderOfElement = index;
            }
            ++index;
        }
        return orderOfElement;
    }

    protected ArrayList<CanvasElement> getElementsInOrder() {
        ArrayList<CanvasElement> elements = new ArrayList<CanvasElement>();
        Iterator i$ = this.elementOrder.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            elements.add(this.canvasElements.get(id));
        }
        return elements;
    }

    protected CanvasElement getTopElementAt(int x, int y) {
        for (CanvasElement canvasElement : this.getElementsInOrder()) {
            if (!canvasElement.containsPoint(x, y)) continue;
            return canvasElement;
        }
        return null;
    }

    private Shape createDefaultInsertBounds(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle bounds = (Rectangle)shape;
            if (bounds.isEmpty()) {
                int maxWidth = this.getWidth() - bounds.x;
                int maxHeight = this.getHeight() - bounds.y;
                maxWidth = maxWidth < 0 ? 0 : maxWidth;
                maxHeight = maxHeight < 0 ? 0 : maxHeight;
                int defaultWidth = DEFAULT_BOUNDS_WIDTH > maxWidth ? maxWidth : DEFAULT_BOUNDS_WIDTH;
                int defaultHeight = DEFAULT_BOUNDS_HEIGHT > maxHeight ? maxHeight : DEFAULT_BOUNDS_HEIGHT;
                return new Rectangle(bounds.x, bounds.y, defaultWidth, defaultHeight);
            }
            return bounds;
        }
        if (shape instanceof Line2D) {
            Line2D line = (Line2D)shape;
            int maxWidth = (int)((double)this.getWidth() - line.getX1());
            int maxHeight = (int)((double)this.getHeight() - line.getY1());
            maxWidth = maxWidth < 0 ? 0 : maxWidth;
            maxHeight = maxHeight < 0 ? 0 : maxHeight;
            int defaultWidth = DEFAULT_BOUNDS_WIDTH > maxWidth ? maxWidth : DEFAULT_BOUNDS_WIDTH;
            int defaultHeight = DEFAULT_BOUNDS_HEIGHT > maxHeight ? maxHeight : DEFAULT_BOUNDS_HEIGHT;
            return new Line2D.Double(line.getX1(), line.getY1(), line.getX1() + (double)defaultWidth, line.getY1() + (double)defaultHeight);
        }
        return shape;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void removeAllCanvasElements() {
        this.elementOrder.clear();
        this.canvasElements.clear();
    }

    @Override
    public Component getComponent() {
        return this.getPanel();
    }

    static {
        DEFAULT_BOUNDS_HEIGHT = DEFAULT_BOUNDS_WIDTH = 50;
    }

    private class DelayedEventDispatcher
    extends Thread {
        private final long delay = 100L;
        private Event event;
        private boolean aborted = false;

        private DelayedEventDispatcher() {
        }

        public void abort() {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setEvent(Event event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.aborted) {
                Canvas.this.eventDispatcher.dispatchEvent(this.event);
            }
        }
    }

    private class CanvasKeyboardListener
    implements KeyListener {
        private CanvasKeyboardListener() {
        }

        @Override
        public void keyTyped(KeyEvent paramKeyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent paramKeyEvent) {
            int elementId = Canvas.this.viewState.getElementFocused();
            if (paramKeyEvent.getKeyCode() == 127) {
                if (elementId >= 0) {
                    Canvas.this.viewState.setElementFocused(-2);
                    Canvas.this.viewState.setElementSlightlyFocused(-2);
                    Canvas.this.eventDispatcher.dispatchEvent(new RemoveCanvasElementEvent(elementId));
                }
            } else if (paramKeyEvent.getKeyCode() == 116) {
                Canvas.this.eventDispatcher.dispatchEvent(new RefreshViewEvent());
            } else if (elementId >= 0) {
                if (paramKeyEvent.getKeyCode() == 38) {
                    Canvas.this.eventDispatcher.dispatchEvent(new MoveElementEvent(elementId, MoveDirection.UP));
                } else if (paramKeyEvent.getKeyCode() == 40) {
                    Canvas.this.eventDispatcher.dispatchEvent(new MoveElementEvent(elementId, MoveDirection.DOWN));
                } else if (paramKeyEvent.getKeyCode() == 37) {
                    Canvas.this.eventDispatcher.dispatchEvent(new MoveElementEvent(elementId, MoveDirection.LEFT));
                } else if (paramKeyEvent.getKeyCode() == 39) {
                    Canvas.this.eventDispatcher.dispatchEvent(new MoveElementEvent(elementId, MoveDirection.RIGHT));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent paramKeyEvent) {
        }
    }

    private class CanvasMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private CanvasMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent paramMouseEvent) {
            CanvasElement canvasElement;
            if (Canvas.this.delayedDispatcher != null) {
                Canvas.this.delayedDispatcher.abort();
            }
            if ((canvasElement = Canvas.this.getTopElementAt(paramMouseEvent.getX(), paramMouseEvent.getY())) != null) {
                if (paramMouseEvent.getClickCount() == 2) {
                    Canvas.this.eventDispatcher.dispatchEvent(new ElementDoubleClickEvent());
                } else {
                    canvasElement.handleMouseClicked(paramMouseEvent);
                    Canvas.this.getPanel().requestFocus();
                    Canvas.this.viewState.setElementFocused(canvasElement.getId());
                    Canvas.this.eventDispatcher.dispatchEvent(new ElementFocusChangedEvent());
                }
            } else {
                Canvas.this.viewState.setElementFocused(-1);
                Canvas.this.eventDispatcher.dispatchEvent(new ElementFocusChangedEvent());
            }
        }

        @Override
        public void mousePressed(MouseEvent paramMouseEvent) {
            CanvasElement canvasElement;
            Canvas.this.eventDispatcher.dispatchEvent(new CanvasFocusEvent());
            if (Canvas.this.insertionMode.isDeactivated() && paramMouseEvent.getButton() == 3) {
                Canvas.this.dragStart = new Point(paramMouseEvent.getX(), paramMouseEvent.getY());
                Canvas.this.elementBeingDragged = -2;
                return;
            }
            Canvas.this.delayedDispatcher = new DelayedEventDispatcher();
            Canvas.this.getPanel().requestFocus();
            if (Canvas.this.insertionMode.isActivated()) {
                Shape shape = null;
                if (Canvas.this.insertionMode.isRectangle()) {
                    shape = new Rectangle(paramMouseEvent.getX() - Canvas.this.viewState.getViewX(), paramMouseEvent.getY() - Canvas.this.viewState.getViewY(), 0, 0);
                } else if (Canvas.this.insertionMode.isTwoPoint()) {
                    shape = new Line2D.Double(paramMouseEvent.getX() - Canvas.this.viewState.getViewX(), paramMouseEvent.getY() - Canvas.this.viewState.getViewY(), paramMouseEvent.getX() - Canvas.this.viewState.getViewX(), paramMouseEvent.getY() - Canvas.this.viewState.getViewY());
                }
                Canvas.this.insertingElement = new InsertingCanvasElement(Canvas.this.insertionMode, Canvas.this, Canvas.this.viewState.getViewX() + paramMouseEvent.getX(), Canvas.this.viewState.getViewY() + paramMouseEvent.getY(), shape, Canvas.this.imageWidth, Canvas.this.imageHeight, Canvas.this.rotation);
                Canvas.this.addCanvasElement(Canvas.this.insertingElement);
            }
            CanvasElement canvasElement2 = canvasElement = Canvas.this.insertionMode.isActivated() ? Canvas.this.insertingElement : Canvas.this.getTopElementAt(paramMouseEvent.getX(), paramMouseEvent.getY());
            if (canvasElement != null) {
                Canvas.this.elementBeingDragged = canvasElement.getId();
                Canvas.this.bringToFront(canvasElement.getId());
                Canvas.this.dragStart = new Point(paramMouseEvent.getX(), paramMouseEvent.getY());
                Canvas.this.elementBoundsAtDragStart = canvasElement.getBounds();
                Canvas.this.viewState.setElementFocused(canvasElement.getId());
                Canvas.this.delayedDispatcher.setEvent(new StartingToResizeEvent(Canvas.this.insertionMode.isActivated() ? -1 : canvasElement.getId()));
                Canvas.this.delayedDispatcher.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent paramMouseEvent) {
            if (Canvas.this.insertionMode.isActivated()) {
                Shape shape = Canvas.this.insertingElement.getBounds();
                if (shape.getBounds().isEmpty()) {
                    shape = Canvas.this.createDefaultInsertBounds(shape);
                }
                Canvas.this.insertionMode = InsertionMode.DEACTIVATED;
                Canvas.this.canvasElements.remove(Canvas.this.insertingElement);
                Canvas.this.insertingElement = null;
                Canvas.this.elementBeingDragged = -1;
                Canvas.this.dragStart = null;
                Canvas.this.elementBoundsAtDragStart = null;
                Canvas.this.eventDispatcher.dispatchEvent(new FinishedInsertingElementEvent(shape));
            } else {
                if (Canvas.this.elementBeingDragged > -1 && !Canvas.this.delayedDispatcher.isAborted()) {
                    Canvas.this.eventDispatcher.dispatchEvent(new FinishedResizingEvent());
                }
                Canvas.this.elementBeingDragged = -1;
                Canvas.this.dragStart = null;
                Canvas.this.elementBoundsAtDragStart = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent paramMouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent paramMouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent paramMouseWheelEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent paramMouseEvent) {
            if (Canvas.this.elementBeingDragged == -2) {
                this.viewportDragged(paramMouseEvent);
            } else if (Canvas.this.elementBeingDragged != -1) {
                this.elementDragged(paramMouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent paramMouseEvent) {
            CanvasElement canvasElement = Canvas.this.getTopElementAt(paramMouseEvent.getX(), paramMouseEvent.getY());
            if (canvasElement != null) {
                Canvas.this.cursorType = canvasElement.getCursor(paramMouseEvent.getX(), paramMouseEvent.getY());
                Canvas.this.parentFrame.setCursor(new Cursor(Canvas.this.cursorType));
                Canvas.this.viewState.setElementSlightlyFocused(canvasElement.getId());
            } else {
                Canvas.this.cursorType = Cursor.getDefaultCursor().getType();
                Canvas.this.parentFrame.setCursor(new Cursor(Canvas.this.cursorType));
                Canvas.this.viewState.setElementSlightlyFocused(-1);
            }
            Canvas.this.getPanel().repaint();
        }

        private void viewportDragged(MouseEvent paramMouseEvent) {
            int dx = paramMouseEvent.getX() - ((Canvas)Canvas.this).dragStart.x;
            int dy = paramMouseEvent.getY() - ((Canvas)Canvas.this).dragStart.y;
            ((Canvas)Canvas.this).dragStart.x = paramMouseEvent.getX();
            ((Canvas)Canvas.this).dragStart.y = paramMouseEvent.getY();
            Canvas.this.eventDispatcher.dispatchEvent(new TranslateViewportEvent(dx, dy));
        }

        private void elementDragged(MouseEvent paramMouseEvent) {
            CanvasElement canvasElement = Canvas.this.getElementWithId(Canvas.this.elementBeingDragged);
            if (canvasElement == null) {
                return;
            }
            int oldX = ((Canvas)Canvas.this).elementBoundsAtDragStart.getBounds().x;
            int oldY = ((Canvas)Canvas.this).elementBoundsAtDragStart.getBounds().y;
            int oldWidth = ((Canvas)Canvas.this).elementBoundsAtDragStart.getBounds().width;
            int oldHeight = ((Canvas)Canvas.this).elementBoundsAtDragStart.getBounds().height;
            int dx = paramMouseEvent.getX() - ((Canvas)Canvas.this).dragStart.x;
            int dy = paramMouseEvent.getY() - ((Canvas)Canvas.this).dragStart.y;
            canvasElement.handleMouseDragged(paramMouseEvent, dx, dy, oldX, oldY, oldWidth, oldHeight, Canvas.this.elementBoundsAtDragStart);
            Shape shape = canvasElement.getOriginalBounds();
            ResizeElementEvent event = new ResizeElementEvent(canvasElement.getId(), shape);
            Canvas.this.eventDispatcher.dispatchEvent(event);
        }
    }
}

