/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.ftp;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.ftp.AbstractConnection;
import at.mrdevelopment.toolkit.ftp.FilenameDownloadSkipper;
import at.mrdevelopment.toolkit.ftp.FtpException;
import at.mrdevelopment.toolkit.ftp.JSchLogger;
import at.mrdevelopment.toolkit.ftp.SkipResourceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.google.common.base.Strings;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;

public class SftpConnection
extends AbstractConnection {
    static ESLLogger logger = ESLLogger.getLogger(SftpConnection.class);
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String directory;
    private final boolean deleteAfterUpload;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPassword;
    private final XMLToolkit xmlToolkit;
    private final JSch jsch;
    private final Properties config;

    public SftpConnection(String host, int port, String username, String password, boolean deleteAfterUpload, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this(host, port, username, password, "", deleteAfterUpload, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public SftpConnection(String host, int port, String username, String password, String directory, boolean deleteAfterUpload, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.directory = directory;
        this.deleteAfterUpload = deleteAfterUpload;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.xmlToolkit = new XMLToolkit();
        JSch.setLogger((Logger)new JSchLogger());
        this.jsch = new JSch();
        this.config = new Properties();
        this.init();
    }

    private void init() {
        this.config.put("StrictHostKeyChecking", "no");
    }

    @Override
    public void exportFile(String filename, File file) throws FtpException {
        logger.info("Exporting file to FTP");
        FileInputStream fileInputStream = null;
        Session session = null;
        boolean uploadDone = false;
        try {
            session = this.connectSession(this.host, this.port, this.username, this.password, this.config, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            ChannelSftp channelSftp = this.connectChannel(session);
            if (!Strings.isNullOrEmpty((String)this.directory)) {
                channelSftp.cd(this.directory);
            }
            logger.info("Writing file to %s", filename);
            fileInputStream = new FileInputStream(file);
            channelSftp.put((InputStream)fileInputStream, filename);
            this.disconnect(channelSftp);
            uploadDone = true;
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                StreamUtils.close(fileInputStream);
                this.disconnect(session);
                throw throwable;
            }
        }
        StreamUtils.close(fileInputStream);
        this.disconnect(session);
        if (uploadDone) {
            this.deleteLocalFile(file, this.deleteAfterUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void exportFileList(String directory, List<File> files, boolean zipBeforeUpload, String infos, int numberOfItems) throws FtpException {
        logger.info("Exporting %s to FTP", infos);
        Session session = null;
        try {
            session = this.connectSession(this.host, this.port, this.username, this.password, this.config, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            ChannelSftp channelSftp = this.connectChannel(session);
            if (!Strings.isNullOrEmpty((String)directory)) {
                channelSftp.cd(directory);
            }
            logger.info("Writing %d %s in %d files to %s", numberOfItems, infos, files.size(), directory);
            for (File file : files) {
                OutputStream outputStream;
                FileInputStream inputStream;
                block13: {
                    inputStream = null;
                    outputStream = null;
                    try {
                        inputStream = new FileInputStream(file);
                        outputStream = channelSftp.put(this.getFilename(file, zipBeforeUpload));
                        if (inputStream != null && outputStream != null) {
                            this.write(outputStream, file.getName(), inputStream, zipBeforeUpload);
                            break block13;
                        }
                        logger.warn("Failed to upload %s to %s (could not open stream)", infos, file.getName());
                    }
                    catch (IOException exception) {
                        logger.warn("Failed to upload %s to %s: %s", infos, file.getName(), exception.getMessage());
                        logger.logExceptionIfDebugEnabled(exception);
                        StreamUtils.close(outputStream);
                        StreamUtils.close(inputStream);
                        continue;
                    }
                    catch (SftpException exception2) {
                        logger.warn("Failed to upload %s to %s: %s", infos, file.getName(), exception2.getMessage());
                        logger.logExceptionIfDebugEnabled(exception2);
                        {
                            catch (Throwable throwable) {
                                StreamUtils.close(outputStream);
                                StreamUtils.close(inputStream);
                                throw throwable;
                            }
                        }
                        StreamUtils.close(outputStream);
                        StreamUtils.close(inputStream);
                        continue;
                    }
                }
                StreamUtils.close(outputStream);
                StreamUtils.close(inputStream);
            }
            this.disconnect(channelSftp);
            this.disconnect(session);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(session);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMarshaller(String directory, String filename, Marshaller marshaller, Object jaxbObject, boolean zipBeforeUpload, String infos) throws FtpException {
        logger.info("Exporting %s to FTP", infos);
        Session session = null;
        try {
            OutputStream outputStream;
            ChannelSftp channelSftp;
            block8: {
                session = this.connectSession(this.host, this.port, this.username, this.password, this.config, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
                channelSftp = this.connectChannel(session);
                if (!Strings.isNullOrEmpty((String)directory)) {
                    channelSftp.cd(directory);
                }
                logger.info("Writing %s to %s", infos, this.getFilename(filename, zipBeforeUpload));
                outputStream = null;
                try {
                    outputStream = channelSftp.put(this.getFilename(filename, zipBeforeUpload));
                    if (outputStream != null) {
                        this.write(outputStream, filename, marshaller, jaxbObject, zipBeforeUpload);
                        break block8;
                    }
                    logger.warn("Failed to upload %s to %s (could not open stream)", infos, filename);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(outputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(outputStream);
            this.disconnect(channelSftp);
            this.disconnect(session);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(session);
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Document> importDocuments(String directory, String filenamePattern, boolean unzipAfterDownload, String infos) throws FtpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int importFiles(String sourceDirectory, String filenamePattern, String destinationDirectory, boolean unzipAfterDownload, boolean skipEqualFiles, boolean deleteFilesAfterImport) throws FtpException {
        logger.info("Importing files from FTP");
        File destination = new File(destinationDirectory);
        FilenameDownloadSkipper downloadSkipper = new FilenameDownloadSkipper(skipEqualFiles, destinationDirectory);
        Pattern filePattern = Pattern.compile(filenamePattern);
        destination.mkdirs();
        Session session = null;
        int importedFiles = 0;
        try {
            session = this.connectSession(this.host, this.port, this.username, this.password, this.config, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            ChannelSftp channelSftp = this.connectChannel(session);
            if (!Strings.isNullOrEmpty((String)sourceDirectory)) {
                channelSftp.cd(sourceDirectory);
            }
            Vector lsEntries = channelSftp.ls(".");
            Iterator i$ = lsEntries.iterator();
            while (true) {
                ChannelSftp.LsEntry file;
                block18: {
                    boolean downloadDone;
                    block17: {
                        Matcher matcher;
                        if (!i$.hasNext()) {
                            this.disconnect(channelSftp);
                            this.disconnect(session);
                            return importedFiles;
                        }
                        file = (ChannelSftp.LsEntry)i$.next();
                        if (file == null || !(matcher = filePattern.matcher(file.getFilename())).matches()) continue;
                        if (downloadSkipper.isSkip() && downloadSkipper.skipResource(file.getFilename())) break block18;
                        InputStream inputStream = null;
                        FileOutputStream outputStream = null;
                        downloadDone = false;
                        try {
                            logger.info("Downloading file %s", file.getFilename());
                            inputStream = channelSftp.get(file.getFilename());
                            if (inputStream != null) {
                                outputStream = new FileOutputStream(new File(destination, unzipAfterDownload ? FilenameUtils.removeExtension((String)file.getFilename()) : file.getFilename()));
                                this.read(inputStream, outputStream, unzipAfterDownload);
                                downloadDone = true;
                            } else {
                                logger.error("Failed to download file %s (could not open stream)", file.getFilename());
                            }
                            StreamUtils.close(outputStream);
                        }
                        catch (SftpException exception) {
                            logger.logException(exception);
                            break block17;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (IOException exception2) {
                                logger.logException(exception2);
                                break block17;
                            }
                        }
                        finally {
                            StreamUtils.close(outputStream);
                            StreamUtils.close(inputStream);
                        }
                        StreamUtils.close(inputStream);
                    }
                    if (!downloadDone) continue;
                    logger.info("Import of file %s finished", file.getFilename());
                    ++importedFiles;
                    this.deleteRemoteFile(channelSftp, file.getFilename(), deleteFilesAfterImport);
                    continue;
                }
                logger.info("Skipping previously downloaded file %s", file.getFilename());
            }
        }
        catch (SkipResourceException exception) {
            try {
                throw new FtpException(exception);
                catch (Exception exception3) {
                    throw new FtpException(exception3);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(session);
                throw throwable;
            }
        }
    }

    private Session connectSession(String host, int port, String username, String password, Properties config, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws JSchException {
        Session session = this.jsch.getSession(username, host, port);
        session.setPassword(password);
        if (!Strings.isNullOrEmpty((String)proxyHost) && proxyPort > 0) {
            ProxyHTTP proxyHTTP = new ProxyHTTP(proxyHost, proxyPort);
            if (!Strings.isNullOrEmpty((String)proxyUser)) {
                proxyHTTP.setUserPasswd(proxyUser, Strings.nullToEmpty((String)proxyPassword));
            }
            session.setProxy((Proxy)proxyHTTP);
        }
        session.setConfig(config);
        session.connect();
        return session;
    }

    private ChannelSftp connectChannel(Session session) throws JSchException {
        Channel channel = session.openChannel("sftp");
        ChannelSftp channelSftp = (ChannelSftp)channel;
        channelSftp.connect();
        return channelSftp;
    }

    private void disconnect(Session session) {
        if (session != null && session.isConnected()) {
            logger.info("Disconnecting from %s", session.getHost());
            session.disconnect();
        }
    }

    private void disconnect(ChannelSftp channelSftp) {
        if (channelSftp != null && channelSftp.isConnected()) {
            channelSftp.disconnect();
        }
    }

    private void deleteRemoteFile(ChannelSftp channelSftp, String path, boolean deleteFile) throws SftpException {
        if (deleteFile) {
            channelSftp.rm(path);
        }
    }
}

