/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.ftp;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.ftp.AbstractConnection;
import at.mrdevelopment.toolkit.ftp.FilenameDownloadSkipper;
import at.mrdevelopment.toolkit.ftp.FtpException;
import at.mrdevelopment.toolkit.ftp.SkipResourceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FtpConnection
extends AbstractConnection {
    static ESLLogger logger = ESLLogger.getLogger(FtpConnection.class);
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String directory;
    private final int timeout;
    private final boolean deleteAfterUpload;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPassword;
    private final XMLToolkit xmlToolkit;

    public FtpConnection(String host, int port, int timeout, String username, String password, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this(host, port, timeout, username, password, "", proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public FtpConnection(String host, int port, int timeout, String username, String password, String directory, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this(host, port, timeout, username, password, directory, false, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public FtpConnection(String host, int port, int timeout, String username, String password, boolean deleteAfterUpload, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this(host, port, timeout, username, password, "", deleteAfterUpload, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public FtpConnection(String host, int port, int timeout, String username, String password, String directory, boolean deleteAfterUpload, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws InitializationException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.directory = directory;
        this.deleteAfterUpload = deleteAfterUpload;
        this.timeout = timeout;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.xmlToolkit = new XMLToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFile(String filename, File file) throws FtpException {
        logger.info("Exporting file to FTP");
        FTPClient ftpClient = null;
        try {
            boolean uploadDone;
            OutputStream outputStream;
            FileInputStream inputStream;
            block9: {
                ftpClient = this.connect(this.host, this.port, this.username, this.password, true, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
                this.changeDirectory(ftpClient, this.directory);
                logger.info("Writing file to %s", filename);
                inputStream = null;
                outputStream = null;
                uploadDone = false;
                try {
                    outputStream = ftpClient.storeFileStream(filename);
                    int intermediateReplyCode = ftpClient.getReplyCode();
                    if (outputStream != null) {
                        inputStream = new FileInputStream(file);
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        uploadDone = true;
                        break block9;
                    }
                    logger.warn("Failed to upload file (could not open stream, reply code was %d)", intermediateReplyCode);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(inputStream);
                    StreamUtils.close(outputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(inputStream);
            StreamUtils.close(outputStream);
            boolean success = ftpClient.completePendingCommand();
            int replyCode = ftpClient.getReplyCode();
            if (uploadDone && success && FTPReply.isPositiveCompletion((int)replyCode)) {
                logger.info("Finished file upload");
                this.deleteLocalFile(file, this.deleteAfterUpload);
            } else {
                logger.warn("Failed to upload file (reply code was %d)", replyCode);
            }
            this.disconnect(ftpClient);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFileList(String directory, List<File> files, boolean zipBeforeUpload, String infos, int numberOfItems) throws FtpException {
        logger.info("Exporting %s to FTP", infos);
        FTPClient ftpClient = null;
        try {
            ftpClient = this.connect(this.host, this.port, this.username, this.password, zipBeforeUpload, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            this.changeDirectory(ftpClient, directory);
            logger.info("Writing %d %s in %d files to %s", numberOfItems, infos, files.size(), directory);
            for (File file : files) {
                OutputStream outputStream;
                FileInputStream inputStream;
                block10: {
                    inputStream = null;
                    outputStream = null;
                    try {
                        inputStream = new FileInputStream(file);
                        outputStream = ftpClient.storeFileStream(this.getFilename(file, zipBeforeUpload));
                        int intermediateReplyCode = ftpClient.getReplyCode();
                        if (inputStream != null && outputStream != null) {
                            this.write(outputStream, file.getName(), inputStream, zipBeforeUpload);
                            break block10;
                        }
                        logger.warn("Failed to upload %s to %s (could not open stream, reply code was %d)", infos, file.getName(), intermediateReplyCode);
                    }
                    catch (IOException exception) {
                        try {
                            logger.warn("Failed to upload %s to %s: %s", infos, file.getName(), exception.getMessage());
                            logger.logExceptionIfDebugEnabled(exception);
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(outputStream);
                            StreamUtils.close(inputStream);
                            throw throwable;
                        }
                        StreamUtils.close(outputStream);
                        StreamUtils.close(inputStream);
                    }
                }
                StreamUtils.close(outputStream);
                StreamUtils.close(inputStream);
                boolean success = ftpClient.completePendingCommand();
                int replyCode = ftpClient.getReplyCode();
                if (success && FTPReply.isPositiveCompletion((int)replyCode)) continue;
                logger.error("Failed to upload %s to %s (reply code was %d)", infos, file.getName(), replyCode);
            }
            this.disconnect(ftpClient);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMarshaller(String directory, String filename, Marshaller marshaller, Object jaxbObject, boolean zipBeforeUpload, String infos) throws FtpException {
        logger.info("Exporting %s to FTP", infos);
        FTPClient ftpClient = null;
        try {
            OutputStream outputStream;
            block9: {
                ftpClient = this.connect(this.host, this.port, this.username, this.password, zipBeforeUpload, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
                this.changeDirectory(ftpClient, directory);
                logger.info("Writing %s to %s", infos, this.getFilename(filename, zipBeforeUpload));
                outputStream = null;
                try {
                    outputStream = ftpClient.storeFileStream(this.getFilename(filename, zipBeforeUpload));
                    int intermediateReplyCode = ftpClient.getReplyCode();
                    if (outputStream != null) {
                        this.write(outputStream, filename, marshaller, jaxbObject, zipBeforeUpload);
                        break block9;
                    }
                    logger.warn("Failed to upload %s to %s (could not open stream, reply code was %d)", infos, filename, intermediateReplyCode);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(outputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(outputStream);
            boolean success = ftpClient.completePendingCommand();
            int replyCode = ftpClient.getReplyCode();
            if (success && FTPReply.isPositiveCompletion((int)replyCode)) {
                logger.info("Finished %s upload to %s", infos, filename);
            } else {
                logger.warn("Failed to upload %s to %s (reply code was %d)", infos, filename, replyCode);
            }
            this.disconnect(ftpClient);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Map<String, Document> importDocuments(String directory, String filenamePattern, boolean unzipAfterDownload, String infos) throws FtpException {
        logger.info("Importing %s from FTP", infos);
        Pattern filePattern = Pattern.compile(filenamePattern);
        FTPClient ftpClient = null;
        HashMap<String, Document> documents = new HashMap<String, Document>();
        try {
            ftpClient = this.connect(this.host, this.port, this.username, this.password, unzipAfterDownload, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            this.changeDirectory(ftpClient, directory);
            for (FTPFile file : ftpClient.listFiles()) {
                boolean downloadDone;
                block15: {
                    Matcher matcher;
                    if (file == null || !(matcher = filePattern.matcher(file.getName())).matches()) continue;
                    InputStream inputStream = null;
                    downloadDone = false;
                    try {
                        logger.info("Downloading file %s", file.getName());
                        inputStream = ftpClient.retrieveFileStream(file.getName());
                        int intermediateReplyCode = ftpClient.getReplyCode();
                        if (inputStream != null) {
                            Element root = this.xmlToolkit.getDocumentRootFromInputStream(unzipAfterDownload ? this.unwrapZipStream(inputStream) : inputStream);
                            documents.put(unzipAfterDownload ? FilenameUtils.removeExtension((String)file.getName()) : file.getName(), root.getOwnerDocument());
                            downloadDone = true;
                        } else {
                            logger.error("Failed to download file %s (could not open stream, reply code was %d)", file.getName(), intermediateReplyCode);
                        }
                        StreamUtils.close(inputStream);
                    }
                    catch (SerializeException exception) {
                        logger.logException(exception);
                    }
                    catch (IOException exception2) {
                        logger.logException(exception2);
                        break block15;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        StreamUtils.close(inputStream);
                    }
                }
                boolean success = ftpClient.completePendingCommand();
                int replyCode = ftpClient.getReplyCode();
                if (downloadDone && success && FTPReply.isPositiveCompletion((int)replyCode)) {
                    logger.info("Import of file %s finished", file.getName());
                    this.deleteRemoteFile(ftpClient, file, this.deleteAfterUpload);
                    continue;
                }
                logger.error("Failed to download file %s (reply code was %d)", file.getName(), replyCode);
            }
            this.disconnect(ftpClient);
        }
        catch (Exception exception) {
            try {
                throw new FtpException(exception);
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int importFiles(String sourceDirectory, String filenamePattern, String destinationDirectory, boolean unzipAfterDownload, boolean skipEqualFiles, boolean deleteFilesAfterImport) throws FtpException {
        logger.info("Importing files from FTP");
        File destination = new File(destinationDirectory);
        FilenameDownloadSkipper downloadSkipper = new FilenameDownloadSkipper(skipEqualFiles, destinationDirectory);
        Pattern filePattern = Pattern.compile(filenamePattern);
        destination.mkdirs();
        FTPClient ftpClient = null;
        int importedFiles = 0;
        try {
            ftpClient = this.connect(this.host, this.port, this.username, this.password, unzipAfterDownload, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
            this.changeDirectory(ftpClient, sourceDirectory);
            FTPFile[] arr$ = ftpClient.listFiles();
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                block17: {
                    FTPFile file;
                    block18: {
                        boolean downloadDone;
                        block16: {
                            Matcher matcher;
                            if (i$ >= len$) {
                                this.disconnect(ftpClient);
                                return importedFiles;
                            }
                            file = arr$[i$];
                            if (file == null || !(matcher = filePattern.matcher(file.getName())).matches()) break block17;
                            if (downloadSkipper.isSkip() && downloadSkipper.skipResource(file.getName())) break block18;
                            InputStream inputStream = null;
                            FileOutputStream outputStream = null;
                            downloadDone = false;
                            try {
                                logger.info("Downloading file %s", file.getName());
                                inputStream = ftpClient.retrieveFileStream(file.getName());
                                int intermediateReplyCode = ftpClient.getReplyCode();
                                if (inputStream != null) {
                                    outputStream = new FileOutputStream(new File(destination, unzipAfterDownload ? FilenameUtils.removeExtension((String)file.getName()) : file.getName()));
                                    this.read(inputStream, outputStream, unzipAfterDownload);
                                    downloadDone = true;
                                } else {
                                    logger.error("Failed to download file %s (could not open stream, reply code was %d)", file.getName(), intermediateReplyCode);
                                }
                                StreamUtils.close(outputStream);
                            }
                            catch (IOException exception) {
                                logger.logException(exception);
                                break block16;
                            }
                            StreamUtils.close(inputStream);
                            break block16;
                            finally {
                                StreamUtils.close(outputStream);
                                StreamUtils.close(inputStream);
                            }
                        }
                        boolean success = ftpClient.completePendingCommand();
                        int replyCode = ftpClient.getReplyCode();
                        if (downloadDone && success && FTPReply.isPositiveCompletion((int)replyCode)) {
                            logger.info("Import of file %s finished", file.getName());
                            ++importedFiles;
                            this.deleteRemoteFile(ftpClient, file, deleteFilesAfterImport && success && FTPReply.isPositiveCompletion((int)replyCode));
                            break block17;
                        } else {
                            logger.error("Failed to download file %s (could not open stream, reply code was %d)", file.getName(), replyCode);
                        }
                        break block17;
                    }
                    logger.info("Skipping previously downloaded file %s", file.getName());
                }
                ++i$;
            }
        }
        catch (SkipResourceException exception) {
            try {
                throw new FtpException(exception);
                catch (Exception exception2) {
                    throw new FtpException(exception2);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
    }

    private FTPClient connect(String host, int port, String username, String password, boolean useBinaryMode, int timeout, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws SocketException, IOException, FtpException {
        FTPClient ftpClient;
        if (!Strings.isNullOrEmpty((String)proxyHost)) {
            logger.debug("Using proxy %s:%d with credentials %s:*****", proxyHost, proxyPort, proxyUser);
            ftpClient = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
        } else {
            ftpClient = new FTPClient();
        }
        ftpClient.setConnectTimeout(timeout);
        ftpClient.setDataTimeout(timeout);
        ftpClient.connect(host, port);
        ftpClient.enterLocalPassiveMode();
        ftpClient.setPassiveNatWorkaround(true);
        logger.info("Connected to %s", ftpClient.getRemoteAddress().toString());
        if (username != null && password != null && !ftpClient.login(username, password)) {
            throw new FtpException("Could not login to FTP host", new Object[0]);
        }
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new FtpException("FTP host refused connection (reply code was %d)", reply);
        }
        if (useBinaryMode) {
            ftpClient.setFileType(2);
        }
        return ftpClient;
    }

    private void disconnect(FTPClient ftpClient) {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                logger.info("Disconnecting from %s", ftpClient.getRemoteAddress().toString());
                ftpClient.disconnect();
            }
            catch (Exception exception) {
                logger.logException(exception);
            }
        }
    }

    private void changeDirectory(FTPClient ftpClient, String directory) throws IOException, FtpException {
        if (directory != null && !directory.isEmpty() && !ftpClient.changeWorkingDirectory(directory)) {
            throw new FtpException("Failed to change to directory %s", directory);
        }
    }

    private void deleteRemoteFile(FTPClient ftpClient, FTPFile file, boolean deleteFile) throws IOException {
        if (deleteFile && !ftpClient.deleteFile(file.getName())) {
            logger.warn("Failed to delete %s", file.getName());
        }
    }
}

