/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.ftp;

import at.mrdevelopment.toolkit.ftp.DownloadSkipper;
import at.mrdevelopment.toolkit.ftp.SkipResourceException;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class FilenameDownloadSkipper
implements DownloadSkipper<String> {
    private final File downloadFolder;
    private final boolean skip;

    public FilenameDownloadSkipper(boolean skip, String downloadFolder) {
        this.skip = skip;
        this.downloadFolder = new File(downloadFolder);
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public boolean skipResource(String resource) throws SkipResourceException {
        if (resource == null) {
            return true;
        }
        return this.containsFile(resource);
    }

    private boolean containsFile(String newFileName) throws SkipResourceException {
        if (this.isFolderOk()) {
            for (String fileName : this.downloadFolder.list()) {
                if (!this.stripExtensions(fileName).equalsIgnoreCase(this.stripExtensions(newFileName))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFolderOk() throws SkipResourceException {
        if (this.downloadFolder == null) {
            throw new SkipResourceException("Download folder must not be null", new Object[0]);
        }
        if (!this.downloadFolder.exists()) {
            throw new SkipResourceException("Download folder %s doesn't exist", this.downloadFolder.getName());
        }
        if (!this.downloadFolder.isDirectory()) {
            throw new SkipResourceException("Download folder %s is not a directory", this.downloadFolder.getName());
        }
        if (!this.downloadFolder.canWrite()) {
            throw new SkipResourceException("Download folder %s is not writable", this.downloadFolder.getName());
        }
        return true;
    }

    private String stripExtensions(String fileName) {
        while (this.hasExtension(fileName)) {
            fileName = FilenameUtils.removeExtension((String)fileName);
        }
        return fileName;
    }

    private boolean hasExtension(String fileName) {
        return fileName.indexOf(46) >= 0;
    }
}

