/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.ftp;

import at.mrdevelopment.esl.toolkit.file.FileDeleter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.ftp.Connection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractConnection
implements Connection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream outputStream, String filename, Marshaller marshaller, Object jaxbObject, boolean zipBeforeUpload) throws JAXBException, IOException {
        block3: {
            block2: {
                if (!zipBeforeUpload) break block2;
                ZipArchiveOutputStream zipArchiveOutputStream = null;
                try {
                    zipArchiveOutputStream = new ZipArchiveOutputStream(outputStream);
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(filename);
                    zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    marshaller.marshal(jaxbObject, (OutputStream)zipArchiveOutputStream);
                    zipArchiveOutputStream.closeArchiveEntry();
                    zipArchiveOutputStream.finish();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(zipArchiveOutputStream);
                    throw throwable;
                }
                StreamUtils.close((OutputStream)zipArchiveOutputStream);
                break block3;
            }
            marshaller.marshal(jaxbObject, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream outputStream, String filename, InputStream inputStream, boolean zipBeforeUpload) throws IOException {
        block3: {
            block2: {
                if (!zipBeforeUpload) break block2;
                ZipArchiveOutputStream zipArchiveOutputStream = null;
                try {
                    zipArchiveOutputStream = new ZipArchiveOutputStream(outputStream);
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(filename);
                    zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipArchiveOutputStream);
                    zipArchiveOutputStream.closeArchiveEntry();
                    zipArchiveOutputStream.finish();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(zipArchiveOutputStream);
                    throw throwable;
                }
                StreamUtils.close((OutputStream)zipArchiveOutputStream);
                break block3;
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(InputStream inputStream, OutputStream outputStream, boolean unzip) throws IOException {
        block3: {
            block2: {
                if (!unzip) break block2;
                ZipArchiveInputStream zipArchiveInputStream = null;
                try {
                    zipArchiveInputStream = new ZipArchiveInputStream(inputStream);
                    zipArchiveInputStream.getNextZipEntry();
                    IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(zipArchiveInputStream);
                    throw throwable;
                }
                StreamUtils.close((InputStream)zipArchiveInputStream);
                break block3;
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream unwrapZipStream(InputStream inputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ZipArchiveInputStream zipArchiveInputStream = null;
        try {
            zipArchiveInputStream = new ZipArchiveInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zipArchiveInputStream.getNextZipEntry();
            IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            StreamUtils.close(zipArchiveInputStream);
            throw throwable;
        }
        StreamUtils.close((InputStream)zipArchiveInputStream);
        return byteArrayInputStream;
    }

    protected void deleteLocalFile(File file, boolean deleteFile) {
        if (deleteFile) {
            FileDeleter.deleteFile(file);
        }
    }

    protected String getFilename(File file, boolean zipBeforeUpload) {
        return this.getFilename(file.getName(), zipBeforeUpload);
    }

    protected String getFilename(String filename, boolean zipBeforeUpload) {
        return zipBeforeUpload ? String.format("%s.zip", filename) : filename;
    }
}

