/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.firmware;

import at.mrdevelopment.toolkit.firmware.LabelLookupTable;
import java.util.concurrent.TimeUnit;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class LookupTableEntry {
    private static final PeriodFormatter FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix(" day", " days").appendSeparator(", ", " and ").appendHours().appendSuffix(" hour", " hours").appendSeparator(", ", " and ").appendMinutes().appendSuffix(" minute", " minutes").appendSeparator(", ", " and ").appendSeconds().appendSuffix(" second", " seconds").toFormatter();
    private final LabelLookupTable.LookupTableIndex index;
    private final int value;
    private final TimeUnit timeUnit;

    public LookupTableEntry(LabelLookupTable.LookupTableIndex index, int value, TimeUnit timeUnit) {
        this.index = index;
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public LabelLookupTable.LookupTableIndex getIndex() {
        return this.index;
    }

    public int getValue() {
        return this.value;
    }

    public String getDisplayableFormat() {
        long millis = this.timeUnit.toMillis(this.value);
        Period period = new Period(millis);
        return millis == 0L ? "0" : FORMATTER.print((ReadablePeriod)period.normalizedStandard());
    }

    public String toString() {
        return this.getDisplayableFormat();
    }
}

