/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.firmware;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class LabelLookupTable {
    private final int[][] lookupTable;

    public LabelLookupTable(int stepCount, int[] base, int[] add) {
        if (base == null || base.length < 1 || add == null || add.length < 1 || add.length != base.length) {
            throw new IllegalArgumentException("Invalid lookup table definition");
        }
        this.lookupTable = new int[base.length][stepCount];
        for (int baseIndex = 0; baseIndex < base.length; ++baseIndex) {
            for (int step = 0; step < stepCount; ++step) {
                int value;
                int addValue = add[baseIndex];
                int baseValue = base[baseIndex];
                this.lookupTable[baseIndex][step] = value = step == 0 ? addValue * baseValue : step * baseValue + addValue * baseValue;
            }
        }
    }

    public LookupTableIndex findClosestMatch(int value) {
        int closestBaseIndex = 0;
        int closestStepIndex = 0;
        int difference = Integer.MAX_VALUE;
        for (int baseIndex = 0; baseIndex < this.lookupTable.length; ++baseIndex) {
            int[] steps = this.lookupTable[baseIndex];
            for (int stepIndex = 0; stepIndex < steps.length; ++stepIndex) {
                int currentValue = steps[stepIndex];
                int currentDifference = Math.abs(value - currentValue);
                if (value > currentValue && (baseIndex != this.lookupTable.length - 1 || stepIndex != steps.length - 1) || currentDifference >= difference) continue;
                closestBaseIndex = baseIndex;
                closestStepIndex = stepIndex;
                difference = currentDifference;
            }
        }
        return new LookupTableIndex(closestBaseIndex, closestStepIndex);
    }

    public List<LookupTableIndex> getIndices() {
        ArrayList<LookupTableIndex> indices = new ArrayList<LookupTableIndex>();
        for (int baseIndex = 0; baseIndex < this.lookupTable.length; ++baseIndex) {
            int[] steps = this.lookupTable[baseIndex];
            for (int stepIndex = 0; stepIndex < steps.length; ++stepIndex) {
                indices.add(new LookupTableIndex(baseIndex, stepIndex));
            }
        }
        return indices;
    }

    public int getValue(LookupTableIndex index) {
        return this.lookupTable[index.getBaseIndex()][index.getStepIndex()];
    }

    public void printLookupTable() {
        for (int baseIndex = 0; baseIndex < this.lookupTable.length; ++baseIndex) {
            int[] steps = this.lookupTable[baseIndex];
            System.out.println(Joiner.on((String)"\t").join((Object[])ArrayUtils.toObject((int[])steps)));
        }
    }

    public class LookupTableIndex {
        private final int baseIndex;
        private final int stepIndex;

        LookupTableIndex(int baseIndex, int stepIndex) {
            this.baseIndex = baseIndex;
            this.stepIndex = stepIndex;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }

        public int getStepIndex() {
            return this.stepIndex;
        }
    }
}

