/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.firmware;

import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FirmwareXMLSerializer
implements XMLSerializer<Firmware> {
    private static final int MAX_ENCRYPTION_BLOCK_SIZE = 117;
    private static final int ENCRYPTED_BLOCK_SIZE = 128;
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Firmware firmware, Key privateKey) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, firmware, privateKey));
        return document;
    }

    public Document toXML(Firmware firmware, Key secretKey, byte[] iv) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, firmware, secretKey, iv));
        return document;
    }

    public Element toXML(Document document, Firmware firmware, Key privateKey) throws SerializeException {
        try {
            Element root = document.createElement("firmware");
            root.setAttribute("device", Integer.toString(firmware.getDeviceType()));
            root.setAttribute("version", firmware.getVersion().getVersionString());
            root.setTextContent("\n" + this.encryptFirmwareImage(firmware.getFirmwareImage(), privateKey));
            return root;
        }
        catch (Exception exc) {
            throw new SerializeException(exc);
        }
    }

    private Element toXML(Document document, Firmware firmware, Key aesKey, byte[] iv) throws SerializeException {
        try {
            Element root = document.createElement("firmware");
            root.setAttribute("device", Integer.toString(firmware.getDeviceType()));
            root.setAttribute("version", firmware.getVersion().getVersionString());
            Base64 base = new Base64();
            String base64Iv = base.encodeToString(iv);
            root.setTextContent("\n" + base64Iv + this.aesEncryptFirmwareImage(firmware.getFirmwareImage(), aesKey, iv, base));
            return root;
        }
        catch (Exception exc) {
            throw new SerializeException(exc);
        }
    }

    public Firmware parseXML(Element element, Key publicKey) throws SerializeException {
        try {
            FirmwareImage firmwareImage = this.getFirmwareImageFromString(element.getTextContent(), publicKey);
            return new Firmware(firmwareImage);
        }
        catch (Exception exc) {
            throw new SerializeException(exc);
        }
    }

    public Firmware parseXML(InputStream inputStream, Key publicKey) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
            return this.parseXML(root, publicKey);
        }
        catch (Exception exc) {
            throw new SerializeException(exc);
        }
    }

    public String parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        if (root.getTagName().equalsIgnoreCase("firmware")) {
            return root.getTextContent();
        }
        throw new SerializeException("Not a firmware.xml. There is no firmware tag present!", new Object[0]);
    }

    private String encryptFirmwareImage(FirmwareImage firmwareImage, Key privateKey) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        byte[] data = firmwareImage.getBytes();
        List<byte[]> blocks = this.splitIntoBlocks(data, 117);
        ArrayList<byte[]> encryptedBlocks = new ArrayList<byte[]>();
        int totalSize = 0;
        for (byte[] block : blocks) {
            byte[] encryptedData = cipher.doFinal(block);
            encryptedBlocks.add(encryptedData);
            totalSize += encryptedData.length;
        }
        byte[] encryptedData = new byte[totalSize];
        int destPosition = 0;
        for (byte[] block : encryptedBlocks) {
            System.arraycopy(block, 0, encryptedData, destPosition, block.length);
            destPosition += block.length;
        }
        return new Base64().encodeToString(encryptedData);
    }

    private String aesEncryptFirmwareImage(FirmwareImage firmwareImage, Key aesKey, byte[] iv, Base64 base64) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "BC");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, aesKey, ivParameterSpec);
        byte[] firmwareData = firmwareImage.getBytes();
        byte[] firmwareWithLength = new byte[4 + firmwareData.length];
        System.out.println("FirmwareDataLength: " + firmwareData.length);
        ByteBuffer bb = ByteBuffer.wrap(firmwareWithLength);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(firmwareData.length);
        bb.put(firmwareData);
        byte[] encryptedData = cipher.doFinal(firmwareWithLength);
        return base64.encodeToString(encryptedData);
    }

    private FirmwareImage getFirmwareImageFromString(String encryptedBase64String, Key key) throws IllegalBlockSizeException, BadPaddingException, InitializationException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, key);
        byte[] data = new Base64().decode(encryptedBase64String);
        List<byte[]> encryptedBlocks = this.splitIntoBlocks(data, 128);
        ArrayList<byte[]> decryptedBlocks = new ArrayList<byte[]>();
        int totalBlockSize = 0;
        for (byte[] block : encryptedBlocks) {
            byte[] decryptedBlock = cipher.doFinal(block);
            decryptedBlocks.add(decryptedBlock);
            totalBlockSize += decryptedBlock.length;
        }
        byte[] decrypt = new byte[totalBlockSize];
        int destPosition = 0;
        for (byte[] block : decryptedBlocks) {
            System.arraycopy(block, 0, decrypt, destPosition, block.length);
            destPosition += block.length;
        }
        return FirmwareImage.decode(new Base64().encodeToString(decrypt));
    }

    private List<byte[]> splitIntoBlocks(byte[] data, int blockSize) {
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        int blockPosition = 0;
        while (blockPosition + blockSize <= data.length) {
            blocks.add(ArrayUtils.subarray((byte[])data, (int)blockPosition, (int)(blockPosition + blockSize)));
            blockPosition += blockSize;
        }
        int remainingBytes = data.length % blockSize;
        if (remainingBytes > 0) {
            blocks.add(ArrayUtils.subarray((byte[])data, (int)(data.length - remainingBytes), (int)data.length));
        }
        return blocks;
    }
}

