/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.firmware;

import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class Firmware
implements Comparable<Firmware> {
    private static final int BOOTLOADER_SIZE = 2048;
    private static final int FIRMWARE_SIZE = 29696;
    private static final int FIRMWARE_SIZE2 = 57344;
    private static final int FIRMWARE_SIZE3 = 118784;
    private static final int FIRMWARE_SIZE4 = 122880;
    private static final int INFO_BLOCK_VERSION_ADDRESS = 29693;
    private static final int FIRMWARE_VERSION_ADDRESS = 29692;
    private static final int DEVICE_TYPE_ADDRESS = 29691;
    private static final int EXTENDED_FIRMWARE_VERSION_ADDRESS_LSB = 29681;
    private static final int EXTENDED_FIRMWARE_VERSION_ADDRESS_MSB = 29682;
    private static final int INFO_BLOCK_VERSION_1 = 1;
    private static final int INFO_BLOCK_VERSION_2 = 2;
    private int deviceType;
    private Version version;
    private final FirmwareImage firmwareImage;
    private boolean forceFirmwareUpdate;

    public Firmware(FirmwareImage firmwareImage) throws SerializeException {
        this(firmwareImage, false);
    }

    public Firmware(FirmwareImage firmwareImage, boolean forceFirmwareUpdate) throws SerializeException {
        this.firmwareImage = firmwareImage;
        this.forceFirmwareUpdate = forceFirmwareUpdate;
        if (firmwareImage.getSize() != 29696 && firmwareImage.getSize() != 57344 && firmwareImage.getSize() != 118784 && firmwareImage.getSize() != 122880) {
            throw new SerializeException("Wrong firmware image size", new Object[0]);
        }
        if (firmwareImage.getByte(29693) == 1) {
            this.deviceType = firmwareImage.getByte(29691);
            this.version = this.loadInfoBlockVersion(firmwareImage, 29692, 29682, 29681);
        } else if (firmwareImage.getByte(firmwareImage.getSize() - 5) == 1 || firmwareImage.getByte(firmwareImage.getSize() - 5) == 2) {
            this.deviceType = 0;
            this.version = this.loadInfoBlockVersion(firmwareImage, firmwareImage.getSize() - 6, firmwareImage.getSize() - 21, firmwareImage.getSize() - 22);
        } else {
            throw new SerializeException("Unsupported info block version %02X", firmwareImage.getByte(29693));
        }
    }

    private Version loadInfoBlockVersion(FirmwareImage firmwareImage, int versionAddress, int extendedAddressMsb, int extendedAddressLsb) {
        Version firmwareVersion = Version.fromByte(firmwareImage.getByte(versionAddress));
        int buildNumber = (0xFF & firmwareImage.getByte(extendedAddressMsb)) << 8 | 0xFF & firmwareImage.getByte(extendedAddressLsb);
        return new Version(firmwareVersion, buildNumber == 65535 ? 0 : buildNumber);
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean getForceUpdateFlag() {
        return this.forceFirmwareUpdate;
    }

    public FirmwareImage getFirmwareImage() {
        return this.firmwareImage;
    }

    public void clearForceUpdateFlag() {
        this.forceFirmwareUpdate = false;
    }

    @Override
    public int compareTo(Firmware other) {
        return this.version.compareTo(other.version);
    }
}

