/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.GzArchive;
import at.mrdevelopment.toolkit.archive.TarArchive;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class UpdateDecompressor {
    static ESLLogger logger = ESLLogger.getLogger(UpdateDecompressor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean untargz(File archive, File outputDir, String fileToBeDecompressed) {
        TarArchiveInputStream tarInputStream;
        String splittedArchivePath;
        block15: {
            boolean bl;
            block13: {
                File tarFile;
                block14: {
                    splittedArchivePath = archive.getAbsolutePath();
                    while (splittedArchivePath.contains("tar") || splittedArchivePath.contains("gz") || splittedArchivePath.contains("tgz")) {
                        splittedArchivePath = splittedArchivePath.substring(0, splittedArchivePath.lastIndexOf("."));
                    }
                    splittedArchivePath = splittedArchivePath + ".tar";
                    tarInputStream = null;
                    try {
                        GzipCompressorInputStream inputStream = new GzipCompressorInputStream((InputStream)new FileInputStream(archive));
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(splittedArchivePath));
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                        inputStream.close();
                        fileOutputStream.close();
                        tarInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(splittedArchivePath));
                        TarArchiveEntry entry = tarInputStream.getNextTarEntry();
                        while (entry != null) {
                            if (fileToBeDecompressed == null || fileToBeDecompressed.equals(entry.getName())) {
                                logger.info("Unpacking file: %s", fileToBeDecompressed);
                                UpdateDecompressor.unpackEntries(tarInputStream, entry, outputDir);
                                StreamUtils.close((InputStream)tarInputStream);
                                FileUtils.deleteQuietly(new File(splittedArchivePath));
                                if (fileToBeDecompressed != null) {
                                    bl = true;
                                    tarFile = new File(splittedArchivePath);
                                    if (!tarFile.exists()) break block13;
                                    break block14;
                                }
                            }
                            entry = tarInputStream.getNextTarEntry();
                        }
                        break block15;
                    }
                    catch (Exception exc) {
                        logger.warn("Error unpacking file: %s", fileToBeDecompressed);
                        logger.logException(exc);
                        return false;
                    }
                }
                FileUtils.deleteQuietly(tarFile);
            }
            if (tarInputStream == null) return bl;
            StreamUtils.close((InputStream)tarInputStream);
            return bl;
        }
        File tarFile = new File(splittedArchivePath);
        if (tarFile.exists()) {
            FileUtils.deleteQuietly(tarFile);
        }
        if (tarInputStream == null) return false;
        StreamUtils.close((InputStream)tarInputStream);
        return false;
        finally {
            tarFile = new File(splittedArchivePath);
            if (tarFile.exists()) {
                FileUtils.deleteQuietly(tarFile);
            }
            if (tarInputStream != null) {
                StreamUtils.close(tarInputStream);
            }
        }
    }

    public static InputStream untargzFile(File archive, String fileToBeDecompressed, boolean decompressInMemory) {
        return decompressInMemory ? UpdateDecompressor.untargzFileInMemory(archive, fileToBeDecompressed) : UpdateDecompressor.untargzFileWithTempFile(archive, fileToBeDecompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream untargzFileWithTempFile(File archive, String fileToBeDecompressed) {
        ByteArrayInputStream byteArrayInputStream;
        FileOutputStream gzOutputStream = null;
        FileInputStream gzInputStream = null;
        File tempTarFile = new File(archive.getParentFile(), archive.getName() + ".tmp");
        try {
            gzOutputStream = new FileOutputStream(tempTarFile);
            new GzArchive().readStreamFromArchive(archive, (OutputStream)gzOutputStream);
            gzInputStream = new FileInputStream(tempTarFile);
            ByteArrayOutputStream fileContent = new TarArchive().getFileContent(gzInputStream, fileToBeDecompressed);
            byteArrayInputStream = fileContent != null ? new ByteArrayInputStream(fileContent.toByteArray()) : null;
        }
        catch (Exception exc) {
            try {
                logger.warn("Error unpacking file: %s", fileToBeDecompressed);
                logger.logException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(gzOutputStream);
                StreamUtils.close(gzInputStream);
                FileUtils.deleteQuietly(tempTarFile);
                throw throwable;
            }
            StreamUtils.close(gzOutputStream);
            StreamUtils.close(gzInputStream);
            FileUtils.deleteQuietly(tempTarFile);
            return null;
        }
        StreamUtils.close(gzOutputStream);
        StreamUtils.close(gzInputStream);
        FileUtils.deleteQuietly(tempTarFile);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream untargzFileInMemory(File archive, String fileToBeDecompressed) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream gzOutputStream = null;
        ByteArrayInputStream gzInputStream = null;
        try {
            gzOutputStream = new ByteArrayOutputStream();
            new GzArchive().readStreamFromArchive(archive, (OutputStream)gzOutputStream);
            gzInputStream = new ByteArrayInputStream(gzOutputStream.toByteArray());
            ByteArrayOutputStream fileContent = new TarArchive().getFileContent(gzInputStream, fileToBeDecompressed);
            byteArrayInputStream = fileContent != null ? new ByteArrayInputStream(fileContent.toByteArray()) : null;
        }
        catch (Exception exc) {
            try {
                logger.warn("Error unpacking file: %s", fileToBeDecompressed);
                logger.logException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(gzOutputStream);
                StreamUtils.close(gzInputStream);
                throw throwable;
            }
            StreamUtils.close(gzOutputStream);
            StreamUtils.close(gzInputStream);
            return null;
        }
        StreamUtils.close(gzOutputStream);
        StreamUtils.close(gzInputStream);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackEntries(TarArchiveInputStream tarInputStream, TarArchiveEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            new File(outputDir, entry.getName()).mkdirs();
            File subDir = new File(outputDir, entry.getName());
            for (TarArchiveEntry directoryEntry : entry.getDirectoryEntries()) {
                UpdateDecompressor.unpackEntries(tarInputStream, directoryEntry, subDir);
            }
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            byte[] content = new byte[(int)entry.getSize()];
            tarInputStream.read(content);
            if (content.length > 0) {
                IOUtils.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)outputStream);
            }
        }
        finally {
            outputStream.close();
        }
    }
}

