/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.file.CsvReader;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FixedLengthsReader
extends CsvReader {
    static ESLLogger logger = ESLLogger.getLogger(FixedLengthsReader.class);
    private final List<Integer> fixedLengths;
    private final int totalLength;

    public FixedLengthsReader(List<Integer> fixedLengths, boolean skipHeaderLine) {
        super("", skipHeaderLine);
        this.fixedLengths = fixedLengths;
        this.totalLength = this.getTotalLength();
    }

    @Override
    protected String[] readLine(String line) throws IllegalArgumentException {
        if (line.length() != this.totalLength) {
            throw new IllegalArgumentException(String.format("Length of line does not match fixed line length (%d != %d)", line.length(), this.totalLength));
        }
        int startIndex = 0;
        String[] record = new String[this.fixedLengths.size()];
        for (int index = 0; index < this.fixedLengths.size(); ++index) {
            String entry;
            int length = this.fixedLengths.get(index);
            record[index] = entry = StringUtils.substring((String)line, (int)startIndex, (int)(startIndex + length));
            startIndex += length;
        }
        return record;
    }

    private int getTotalLength() {
        int sum = 0;
        for (Integer length : this.fixedLengths) {
            sum += length.intValue();
        }
        return sum;
    }
}

