/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.UnixCodec;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;

public class FileUtils {
    public static final int DEFAULT_SHORTENER_THRESHOLD = 4;
    public static final String SHORTENER_BACKSLASH_REGEX = "\\\\";
    public static final String SHORTENER_SLASH_REGEX = "/";
    public static final String SHORTENER_BACKSLASH = "\\";
    public static final String SHORTENER_SLASH = "/";
    public static final String SHORTENER_ELLIPSE = "...";
    public static final char[] CHAR_LOWERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] CHAR_UPPERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] CHAR_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] CHAR_SPECIALS = new char[]{'.', '-', '_', '!', '@', '$', '^', '*', '=', '~', '|', '+', '?'};
    public static final char[] CHAR_LETTERS = ArrayUtils.addAll((char[])CHAR_LOWERS, (char[])CHAR_UPPERS);
    public static final char[] CHAR_ALPHANUMERICS = ArrayUtils.addAll((char[])CHAR_LETTERS, (char[])CHAR_DIGITS);
    private static final char[] IMMUNE_OS = new char[]{'.', '_', '-'};

    public static void save(String data, String path) throws IOException {
        FileUtils.save(data, new File(path));
    }

    public static void save(String data, File file) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data);
    }

    public static String read(String path) throws IOException {
        return FileUtils.read(new File(path));
    }

    public static String read(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToString((File)file);
    }

    public static List<String> readLines(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readLines((File)file);
    }

    public static String removeExtension(String fileName) {
        return FilenameUtils.removeExtension((String)fileName);
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static FileFilter newFileExtensionFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase(extension);
            }
        };
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals(SHORTENER_BACKSLASH)) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileCompletelyWritten(File file) {
        RandomAccessFile stream = null;
        try {
            stream = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (Exception ignore) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String encodeForUnix(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(FileUtils.encode(c, new UnixCodec(), CHAR_ALPHANUMERICS, IMMUNE_OS));
        }
        return sb.toString();
    }

    private static String encode(char c, UnixCodec codec, char[] baseImmune, char[] specialImmune) {
        if (FileUtils.isContained(baseImmune, c) || FileUtils.isContained(specialImmune, c)) {
            return "" + c;
        }
        return codec.encodeCharacter(new Character(c));
    }

    private static boolean isContained(char[] haystack, char c) {
        for (int i = 0; i < haystack.length; ++i) {
            if (c != haystack[i]) continue;
            return true;
        }
        return false;
    }

    public static File getInstallationPathFile(Class<?> clazz) throws InitializationException {
        String path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path != null) {
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (decodedPath != null) {
                    File file = new File(decodedPath);
                    return file != null ? file.getParentFile() : file;
                }
            }
            catch (UnsupportedEncodingException exc) {
                throw new InitializationException(exc);
            }
        }
        return null;
    }

    public static String getInstallationPath(Class<?> clazz) throws InitializationException {
        File file = FileUtils.getInstallationPathFile(clazz);
        return file != null ? file.getAbsolutePath() : null;
    }

    public static String toReadableSize(long size, int sizeIndex) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups + sizeIndex];
    }

    public static String toReadableSize(long size) {
        return FileUtils.toReadableSize(size, 0);
    }

    static class PathResolutionException
    extends RuntimeException {
        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

