/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.datetime.ReloadInterval;
import at.mrdevelopment.toolkit.datetime.ReloadIntervalFactory;

public abstract class FileBasedPluginImportConfiguration {
    private final boolean enabled;
    private final String importDirectory;
    private final ReloadInterval reloadInterval;
    private final boolean deleteFileAfterImport;
    private final boolean moveFileAfterImport;
    private final String moveDirectory;
    private final boolean writeImportReport;
    private final ReloadIntervalFactory reloadIntervalFactory = new ReloadIntervalFactory();

    public FileBasedPluginImportConfiguration(boolean enabled, String importDirectory, String reloadInterval, boolean deleteFileAfterImport, boolean moveFileAfterImport, String moveDirectory, boolean writeImportReport) throws InitializationException {
        this.enabled = enabled;
        this.importDirectory = importDirectory;
        this.deleteFileAfterImport = deleteFileAfterImport;
        this.moveFileAfterImport = moveFileAfterImport;
        this.moveDirectory = moveDirectory;
        this.writeImportReport = writeImportReport;
        try {
            this.reloadInterval = this.reloadIntervalFactory.parseReloadInterval(reloadInterval);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException(exc);
        }
    }

    public String getImportDirectory() {
        return this.importDirectory;
    }

    public ReloadInterval getReloadInterval() {
        return this.reloadInterval;
    }

    public boolean isDeleteFileAfterImport() {
        return this.deleteFileAfterImport;
    }

    public boolean isMoveFileAfterImport() {
        return this.moveFileAfterImport;
    }

    public String getMoveDirectory() {
        return this.moveDirectory;
    }

    public boolean isWriteImportReport() {
        return this.writeImportReport;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

