/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.AbstractFileReader;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;

public class CsvReader
extends AbstractFileReader {
    static ESLLogger logger = ESLLogger.getLogger(CsvReader.class);
    private final String delimiter;
    private final boolean skipHeaderLine;

    public CsvReader() {
        this(";", false);
    }

    public CsvReader(String delimiter, boolean skipHeaderLine) {
        this.delimiter = delimiter;
        this.skipHeaderLine = skipHeaderLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String[]> read(InputStream inputStream, String charsetName) throws IOException, UnsupportedEncodingException {
        ArrayList<String[]> arrayList;
        BufferedReader reader = null;
        try {
            BOMInputStream bomInputStream = new BOMInputStream(inputStream, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            if (bomInputStream.hasBOM()) {
                charsetName = bomInputStream.getBOMCharsetName();
                logger.info("Using charset %s from stream", charsetName);
            } else {
                logger.debug("Using charset %s", charsetName);
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)bomInputStream, charsetName));
            ArrayList<String[]> lines = new ArrayList<String[]>();
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty() && !line.startsWith("#")) {
                    try {
                        String[] record = this.readLine(line);
                        lines.add(record);
                    }
                    catch (IllegalArgumentException exc) {
                        logger.warn("Could not read line %d: %s", lines.size(), exc.getMessage());
                        logger.logExceptionIfDebugEnabled(exc);
                    }
                }
                line = reader.readLine();
            }
            arrayList = this.skipHeaderLine ? lines.subList(1, lines.size()) : lines;
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close(reader);
        return arrayList;
    }

    protected String[] readLine(String line) throws IllegalArgumentException {
        return StringUtils.splitPreserveAllTokens((String)line, (String)this.delimiter);
    }
}

