/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentProducer;

public class CsvBuilder
implements ContentProducer {
    private static String NEWLINE = "\r\n";
    private final String delimiter;
    private final StringBuilder content;

    public CsvBuilder() {
        this(";");
    }

    public CsvBuilder(String delimiter) {
        this.delimiter = delimiter;
        this.content = new StringBuilder();
    }

    public void addRecord(String ... fields) {
        this.content.append(StringUtils.join((Object[])fields, (String)this.delimiter));
        this.content.append(NEWLINE);
    }

    public void addRecord(List<String> fields) {
        this.content.append(StringUtils.join(fields, (String)this.delimiter));
        this.content.append(NEWLINE);
    }

    public String getContent() {
        return this.content.toString();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
        writer.write(this.getContent());
        ((Writer)writer).flush();
    }
}

