/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import org.apache.commons.io.IOUtils;

public class ApplicationLock {
    static ESLLogger logger = ESLLogger.getLogger(ApplicationLock.class);
    private static ApplicationLock instance;
    File lockFile = null;
    FileLock lock = null;
    FileChannel lockChannel = null;
    FileOutputStream lockStream = null;

    private ApplicationLock() {
    }

    private ApplicationLock(String key) throws InitializationException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith(System.getProperty("file.separator"))) {
            tmpDir = tmpDir + System.getProperty("file.separator");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            String hash_text = new BigInteger(1, md.digest(key.getBytes())).toString(16);
            while (hash_text.length() < 32) {
                hash_text = "0" + hash_text;
            }
            this.lockFile = new File(tmpDir + hash_text + ".app_lock");
            if (this.lockFile == null) {
                this.lockFile = new File(tmpDir + key + ".app_lock");
            }
            this.lockStream = new FileOutputStream(this.lockFile);
            String content = "imagotag Application Lock\r\nLocked by key: " + key + "\r\n";
            IOUtils.write((String)content, (OutputStream)this.lockStream);
            this.lockChannel = this.lockStream.getChannel();
            this.lock = this.lockChannel.tryLock();
            if (this.lock == null) {
                throw new InitializationException("Can't create Lock", new Object[0]);
            }
        }
        catch (Exception exc) {
            logger.warn("Failed to aquire lock file");
            throw new InitializationException(exc);
        }
    }

    private void release() throws Throwable {
        if (this.lock.isValid()) {
            this.lock.release();
        }
        if (this.lockStream != null) {
            this.lockStream.close();
        }
        if (this.lockChannel.isOpen()) {
            this.lockChannel.close();
        }
        if (this.lockFile.exists()) {
            this.lockFile.delete();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public static boolean setLock(String key) {
        if (instance != null) {
            return true;
        }
        try {
            instance = new ApplicationLock(key);
        }
        catch (Exception exc) {
            instance = null;
            logger.warn("Failed to set application lock");
            logger.logExceptionIfDebugEnabled(exc);
            return false;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ApplicationLock.releaseLock();
            }
        });
        return true;
    }

    public static void releaseLock() {
        try {
            if (instance == null) {
                throw new NoSuchFieldException("INSTANCE IS NULL");
            }
            instance.release();
        }
        catch (Throwable exc) {
            logger.warn("Failed to release application lock");
            logger.logExceptionIfDebugEnabled(exc);
        }
    }
}

