/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.CsvBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractImportReport<V, S extends Enum<?>> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    private final CsvBuilder reportBuilder = new CsvBuilder();

    public static String getReportFileNameFromImportFileName(String importFileName) {
        return String.format("%s_report_%s.csv", FilenameUtils.removeExtension((String)importFileName), DATE_TIME_FORMATTER.print((ReadableInstant)DateTime.now()));
    }

    public static String getReportFileName() {
        return String.format("report_%s.csv", DATE_TIME_FORMATTER.print((ReadableInstant)DateTime.now()));
    }

    public void addStatus(V value, S status) {
        this.reportBuilder.addRecord(this.statusToRecord(value, status));
    }

    protected abstract List<String> statusToRecord(V var1, S var2);

    public void writeTo(OutputStream outputStream) throws IOException {
        this.reportBuilder.writeTo(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws FileNotFoundException, IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.writeTo(outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }

    protected void addRecord(String record) {
        this.reportBuilder.addRecord(record);
    }
}

