/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.exec;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;

public class ProcessLauncher {
    public static void launchSystemProcessAsync(String pathToExecutable, String workingDirectory, ExecuteWatchdog executeWatchdog, ExecuteResultHandler executeResultHandler, String ... args) throws IOException {
        ProcessLauncher.launchSystemProcessInternal(pathToExecutable, workingDirectory, executeWatchdog, executeResultHandler, args);
    }

    public static int launchSystemProcessSync(String pathToExecutable, String workingDirectory, String ... args) throws IOException {
        return ProcessLauncher.launchSystemProcessInternal(pathToExecutable, workingDirectory, null, null, args);
    }

    private static int launchSystemProcessInternal(String pathToExecutable, String workingDirectory, ExecuteWatchdog executeWatchdog, ExecuteResultHandler executeResultHandler, String ... args) throws IOException {
        CommandLine cmdLine = new CommandLine(pathToExecutable);
        for (String arg : args) {
            cmdLine.addArgument(arg, true);
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        executor.setWorkingDirectory(new File(workingDirectory));
        if (executeWatchdog == null) {
            executeWatchdog = new ExecuteWatchdog(-1L);
        }
        executor.setWatchdog(executeWatchdog);
        if (executeResultHandler == null) {
            return executor.execute(cmdLine);
        }
        executor.execute(cmdLine, executeResultHandler);
        return 0;
    }
}

