/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc;

import at.mrdevelopment.toolkit.encoding.dc.Binary;
import java.util.Arrays;

public final class MathUtil {
    private static final long HEXA_MAX_VALUE_MORE_ONE = 16L;
    private static final double VALUE_16 = 16.0;
    private static final double VALUE_256 = 256.0;
    private static final int DECIMAL_MAX_VALUE = 9;
    private static final int HEXA_MAX_VALUE = 15;
    private static final double HEXA_A_VALUE = 10.0;
    private static final int BYTE_LONG_COUNT = 4;
    private static final int BYTE_BIT_COUNT = 8;
    private static final int WEAKEST_BYTE = 255;
    private static final int MAX_LENGTH_BINARY_TO_LONG = 40;
    private static final double HEXA_BIT_COUNT = 4.0;

    private MathUtil() {
    }

    public static String toHexString(boolean[] bValue) {
        if (bValue.length == 0) {
            return "0";
        }
        long lValue = 0L;
        for (boolean b : bValue) {
            lValue <<= 1;
            lValue += b ? 1L : 0L;
        }
        int resultSize = (int)Math.ceil((double)bValue.length / 4.0);
        return MathUtil.toHexString(lValue, resultSize);
    }

    public static String toHexString(byte[] value, int bitCount) {
        String result = bitCount % 8 == 0 ? MathUtil.toHexString(value) : (bitCount % 8 <= 4 ? MathUtil.toHexString(value, true) : MathUtil.toHexString(value));
        return result;
    }

    public static String toHexString(Binary binary) {
        return MathUtil.toHexString(binary.getData(), binary.getBitCount());
    }

    public static String toHexString(byte[] value, boolean removeLastHexa) {
        String hex = MathUtil.toHexString(value);
        if (removeLastHexa && hex.length() >= 1) {
            return hex.substring(0, hex.length() - 1);
        }
        return hex;
    }

    public static String toHexString(byte[] value) {
        StringBuilder hexString = new StringBuilder();
        for (byte i : value) {
            if (i >= 0) {
                hexString.append(MathUtil.toHexString(i, 2));
                continue;
            }
            hexString.append(MathUtil.toHexString((int)(256.0 + (double)i), 2));
        }
        return hexString.toString();
    }

    public static String toHexString(String value) {
        return MathUtil.toHexString(value.getBytes());
    }

    public static String toHexString(long value, int paddingLength) {
        return MathUtil.toHexString(value, paddingLength, false);
    }

    public static String toHexString(long value) {
        if (value <= 15L) {
            return new String(new byte[]{MathUtil.toHex(value)});
        }
        return Long.toHexString(value).toUpperCase();
    }

    public static String toBinaryString(long value) {
        return Long.toBinaryString(value);
    }

    public static String toBinaryString(long value, int resultLength) {
        String binaryValue = MathUtil.toBinaryString(value);
        StringBuilder result = new StringBuilder(resultLength);
        for (int i = result.length() + binaryValue.length(); i < resultLength; ++i) {
            result.append('0');
        }
        result.append(binaryValue);
        return result.toString();
    }

    public static String toHexString(long value, int paddingLength, boolean reverse) {
        String hexValue = MathUtil.toHexString(value);
        StringBuilder result = new StringBuilder(paddingLength);
        for (int i = result.length() + hexValue.length(); i < paddingLength; ++i) {
            result.append('0');
        }
        result.append(hexValue);
        if (reverse) {
            return result.reverse().toString();
        }
        return result.toString();
    }

    public static long toHex(int[] indexes) {
        long value = 0L;
        for (int index : indexes) {
            value += (long)(1 << index);
        }
        return value;
    }

    public static String toHexString(int[] indexes) {
        if (0 == indexes.length) {
            return "0";
        }
        int maxIndex = 0;
        long value = 0L;
        for (int index : indexes) {
            value += (long)(1 << index);
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        return MathUtil.toHexString(value, (int)Math.ceil((double)maxIndex / 4.0));
    }

    public static long toHexComp(long value) {
        int bitCount = MathUtil.hexaSize(value) * 4;
        long comp = (1 << bitCount) - 1;
        return comp - value;
    }

    public static int hexaSize(long value) {
        return (int)Math.max(1.0, Math.ceil(MathUtil.log16(value + 1L)));
    }

    public static int octalSize(long value) {
        return (int)Math.max(1.0, Math.ceil(MathUtil.log256(value + 1L)));
    }

    public static int bitCount(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value " + value + " is a negative value");
        }
        if (0L == value) {
            return 1;
        }
        return (int)Math.ceil(MathUtil.log2(value + 1L));
    }

    public static double log2(double pdouble) {
        return Math.log(pdouble) / Math.log(2.0);
    }

    public static double log16(double pDouble) {
        return Math.log(pDouble) / Math.log(16.0);
    }

    public static double log256(double pDouble) {
        return Math.log(pDouble) / Math.log(256.0);
    }

    public static long toLong(int bitToEnd, int[] indexPicto) {
        long result = 0L;
        for (int index : indexPicto) {
            result += (long)(1 << bitToEnd - index);
        }
        return result;
    }

    public static byte checkSumHexa(byte[] bytes) {
        long sumBytes = 0L;
        for (byte c : bytes) {
            sumBytes += (long)MathUtil.fromHex(c);
        }
        long modulo = sumBytes % 16L;
        return 0L == modulo ? (byte)48 : MathUtil.toHex(16L - modulo);
    }

    public static byte toHex(long value) {
        if (value >= 0L) {
            if (value <= 9L) {
                return (byte)(value + 48L);
            }
            if (value <= 15L) {
                return (byte)((double)value - 10.0 + 65.0);
            }
        }
        throw new IllegalArgumentException("value " + value + " is not in hexadecimal range (0-15)");
    }

    public static byte[] toByteArray(int value, int minimalSize) {
        int minimalSizeMaximize = Math.max(minimalSize, MathUtil.octalSize(value));
        byte[] result = new byte[4];
        int tempValue = value;
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (byte)(tempValue & 0xFF);
            tempValue >>= 8;
        }
        byte[] finalResult = Arrays.copyOfRange(result, 4 - minimalSizeMaximize, 4);
        return finalResult;
    }

    public static byte[] fromHex(String hexaString) {
        int lengthOfHexaString = hexaString.length();
        byte[] hex = new byte[lengthOfHexaString / 2 + lengthOfHexaString % 2];
        for (int i = 0; i < lengthOfHexaString; ++i) {
            byte currentNibble = MathUtil.fromHex((byte)hexaString.charAt(i));
            if (i % 2 == 0) {
                hex[i / 2] = (byte)(currentNibble << 4);
                continue;
            }
            int n = i / 2;
            hex[n] = (byte)(hex[n] + currentNibble);
        }
        return hex;
    }

    public static byte fromHex(byte asciiCode) {
        byte result;
        if (asciiCode >= 48 && asciiCode <= 57) {
            result = (byte)(asciiCode - 48);
        } else if (asciiCode >= 65 && asciiCode <= 70) {
            result = (byte)((double)(asciiCode - 65) + 10.0);
        } else if (asciiCode >= 97 && asciiCode <= 102) {
            result = (byte)((double)(asciiCode - 97) + 10.0);
        } else {
            throw new IllegalArgumentException("byte " + asciiCode + " is not an hexadecimal value (0x0 to 0xF)");
        }
        return result;
    }

    public static String toDec(long value, int minLength) {
        if (0L > value) {
            throw new IllegalArgumentException("Negative Value not supported");
        }
        StringBuilder result = new StringBuilder();
        String valueString = Long.toString(value);
        int toAdd = minLength - valueString.length();
        for (int i = 0; i < toAdd; ++i) {
            result.append('0');
        }
        result.append(valueString);
        return result.toString();
    }

    public static String toHexStringFromBinary(String binaryValue) {
        String finalResult;
        if (null == binaryValue) {
            finalResult = null;
        } else {
            int length = binaryValue.length();
            int resultLength = (int)Math.ceil((double)length / 4.0);
            if (0 == length) {
                finalResult = "";
            } else if (length < 40) {
                finalResult = MathUtil.toHexString(Long.parseLong(binaryValue, 2), resultLength);
            } else {
                StringBuilder result = new StringBuilder();
                result.append(MathUtil.toHexString(Long.parseLong(binaryValue.substring(0, 40), 2)));
                result.append(MathUtil.toHexStringFromBinary(binaryValue.substring(40, length)));
                for (int j = result.length(); j < resultLength; ++j) {
                    result.insert(0, '0');
                }
                finalResult = result.toString();
            }
        }
        return finalResult;
    }

    public static String insertIntoBinary(String valeur01, int insertZeroGap) {
        return MathUtil.insertIntoBinary(valeur01, insertZeroGap, insertZeroGap);
    }

    public static String insertIntoBinary(String valeur01, int offset, int insertZeroGap) {
        if (null == valeur01) {
            return null;
        }
        if (insertZeroGap <= 0) {
            throw new IllegalArgumentException("gap between '0' must be greater than 0");
        }
        int finalLength = valeur01.length() + valeur01.length() / insertZeroGap;
        StringBuilder stringBuilder = new StringBuilder(valeur01);
        for (int i = offset; i < finalLength; i += insertZeroGap + 1) {
            stringBuilder.insert(i, '0');
        }
        return stringBuilder.toString();
    }

    public static String toBinaryFromHex(String hexValue) {
        if (null == hexValue) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(hexValue.length() * 4);
        for (byte c : hexValue.getBytes()) {
            String binary = Long.toBinaryString(MathUtil.fromHex(c));
            for (int i = binary.length(); i < 4; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(binary);
        }
        return stringBuilder.toString();
    }

    public static String orOperand(String paramA, String paramB) {
        if (null == paramA || null == paramB) {
            throw new IllegalArgumentException("String must not be not null a=" + paramA + " and b=" + paramB);
        }
        if (paramA.length() != paramB.length()) {
            throw new IllegalArgumentException("arguments must have same length. First argument is " + paramA + " second is " + paramB);
        }
        StringBuilder result = new StringBuilder(paramA.length());
        for (int i = 0; i < paramA.length(); ++i) {
            if ('1' == paramA.charAt(i) || '1' == paramB.charAt(i)) {
                result.append('1');
                continue;
            }
            result.append('0');
        }
        return result.toString();
    }

    public static int computeNextModulo8(int number) {
        int tempNumber = number;
        while (tempNumber % 8 != 0) {
            ++tempNumber;
        }
        return tempNumber;
    }

    public static int computePreviousModulo8(int number) {
        int tempNumber = number;
        while (tempNumber % 8 != 0) {
            --tempNumber;
        }
        return tempNumber;
    }

    public static int binaryComplement(int numberToComplate, int length) {
        int tempValue = 0;
        tempValue = numberToComplate ^ (int)Math.pow(2.0, length) - 1;
        return tempValue;
    }
}

