/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc;

import at.mrdevelopment.toolkit.encoding.dc.Binary;
import at.mrdevelopment.toolkit.encoding.dc.CompressionRuntimeException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageBinary
extends Binary {
    private static final int MAX_BYTE_VALUE = 255;
    private static final int BIT_COUNT_IN_BYTE = 8;
    private static final long serialVersionUID = 1L;
    private final int width;
    private final int height;

    public ImageBinary(int bitCount, byte[] data, int width, int height) {
        super(bitCount, data);
        this.height = height;
        this.width = width;
    }

    public ImageBinary(int defaultValueBit, int width, int height) {
        this(width * height, new byte[1], width, height);
        if (defaultValueBit != 0 && defaultValueBit != 1) {
            throw new IllegalArgumentException("the default value bit must be 0 or 1 and not " + defaultValueBit);
        }
        int numberofByte = width * height % 8 > 0 ? width * height / 8 + 1 : width * height / 8;
        byte[] dataDefault = new byte[numberofByte];
        for (int i = 0; i < dataDefault.length; ++i) {
            dataDefault[i] = defaultValueBit == 1 ? -1 : 0;
        }
        this.setData(dataDefault);
    }

    public ImageBinary(byte[] buffer, int width, int height) {
        super(width * height, buffer);
        this.height = height;
        this.width = width;
    }

    public ImageBinary(Binary binaryFlow, int width, int height) {
        super(binaryFlow.getBitCount(), binaryFlow.getData());
        this.height = height;
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixel(int postionX, int postionY) {
        int position = this.getWidth() * postionY + postionX;
        if (postionX < 0 || postionY < 0 || postionX >= this.getWidth() || postionY >= this.getHeight()) {
            return 0;
        }
        return this.readAt(position);
    }

    public void setPixel(int value, int positionX, int positionY) {
        int position = this.getWidth() * positionY + positionX;
        if (positionX < 0 || positionY < 0 || positionX >= this.getWidth() || positionY >= this.getHeight()) {
            throw new CompressionRuntimeException("Out of range  : " + position + " position bits, " + this.getBitCount() + " content bits ");
        }
        this.writeAt(position, value);
    }

    public String toHumanReadable() {
        StringBuilder stringBuilder = new StringBuilder();
        int line = 0;
        int position = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            stringBuilder.append(String.format("%04d : ", line));
            for (int j = 0; j < this.getWidth(); ++j) {
                stringBuilder.append(String.format("%1d", this.readAt(position++)));
            }
            ++line;
            stringBuilder.append('\n');
        }
        stringBuilder.append(String.format("nb_bit : %d H: %d L: %d", this.getBitCount(), this.getHeight(), this.getWidth()));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public BufferedImage makeBufferedImage() {
        Color colorPix1 = Color.WHITE;
        Color colorPix0 = Color.BLACK;
        BufferedImage returnImage = new BufferedImage(this.getWidth(), this.getHeight(), 13);
        Graphics2D graphics2D = (Graphics2D)returnImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (this.getPixel(x, y) == 1) {
                    graphics2D.setColor(colorPix1);
                } else {
                    graphics2D.setColor(colorPix0);
                }
                graphics2D.fillRect(x, y, 1, 1);
            }
        }
        return returnImage;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageBinary other = (ImageBinary)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }
}

