/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc;

import at.mrdevelopment.toolkit.encoding.dc.Binary;
import at.mrdevelopment.toolkit.encoding.dc.BitInputStream;
import at.mrdevelopment.toolkit.encoding.dc.BitOutputStream;
import at.mrdevelopment.toolkit.encoding.dc.CompressionDC;
import at.mrdevelopment.toolkit.encoding.dc.ImageBinary;

public class CompressionDC3
implements CompressionDC {
    @Override
    public Binary compress(ImageBinary binary) {
        BitOutputStream bitOutputStream = new BitOutputStream();
        int bitReadToCompress = 0;
        int[] runLength = new int[4];
        int[] pixels = new int[4];
        int done = 0;
        int data = 0;
        byte pred = 0;
        byte limitpixel = 0;
        int command = 0;
        int bestRunLen = 0;
        int bestPred = 0;
        for (int positionOfBitRead = 0; positionOfBitRead < binary.getBitCount(); positionOfBitRead += bitReadToCompress) {
            bitReadToCompress = 0;
            for (int indexPredicator = 0; indexPredicator < 2; ++indexPredicator) {
                int j;
                pixels[0] = 6;
                for (j = 0; j < 4; ++j) {
                    runLength[j] = 0;
                }
                data = 0;
                done = 0;
                j = 0;
                while (positionOfBitRead + j <= binary.getBitCount() && done != 15) {
                    switch (indexPredicator) {
                        case 0: {
                            pred = (binary.getPixel((positionOfBitRead + j) % binary.getWidth(), (positionOfBitRead + j) / binary.getWidth() - 1) & 1) == 1 ? (byte)1 : 0;
                            break;
                        }
                        case 1: {
                            pred = (binary.getPixel((positionOfBitRead + j - 2) % binary.getWidth(), (positionOfBitRead + j - 2) / binary.getWidth()) & 1) == 1 ? (byte)1 : 0;
                            break;
                        }
                    }
                    limitpixel = (byte)(binary.getPixel((positionOfBitRead + j) % binary.getWidth(), (positionOfBitRead + j) / binary.getWidth()) == 1 ? 1 : 0);
                    if ((done & 2) == 0) {
                        runLength[1] = Math.min(37, j);
                    }
                    if ((done & 4) == 0) {
                        runLength[2] = Math.min(37, j);
                    }
                    if ((done & 8) == 0) {
                        runLength[3] = Math.min(33, j >> 4);
                    }
                    if (j >= 6) {
                        done = (byte)(done | 1);
                    }
                    if (j >= 37) {
                        done = (byte)(done | 6);
                    }
                    if (j >> 4 >= 33) {
                        done = (byte)(done | 8);
                    }
                    if ((limitpixel ^ pred) != 0) {
                        done = (byte)(done | 0xA);
                    }
                    if ((limitpixel ^ pred) == 0) {
                        done = (byte)(done | 4);
                    }
                    if (j < 6 && limitpixel != 0) {
                        data = (byte)(data | 1 << j);
                    }
                    ++j;
                }
                pixels[1] = runLength[1];
                pixels[2] = runLength[2];
                if (runLength[1] < 37) {
                    pixels[1] = pixels[1] + 1;
                }
                if (runLength[2] < 37) {
                    pixels[2] = pixels[2] + 1;
                }
                pixels[3] = runLength[3] << 4;
                for (j = 0; j < 4; ++j) {
                    if (pixels[j] <= bitReadToCompress) continue;
                    bitReadToCompress = pixels[j];
                    command = j;
                    bestPred = indexPredicator;
                    bestRunLen = runLength[j];
                }
            }
            int symbol = command << 6 | bestPred << 5;
            switch (command) {
                case 0: {
                    symbol = data;
                    break;
                }
                case 1: {
                    symbol |= bestRunLen - 6;
                    break;
                }
                case 2: {
                    symbol |= bestRunLen - 6;
                    break;
                }
                case 3: {
                    symbol |= bestRunLen - 2;
                    break;
                }
            }
            bitOutputStream.write(symbol, 8);
        }
        return bitOutputStream.getBinary();
    }

    @Override
    public Binary uncompress(ImageBinary binary) {
        ImageBinary imageBinary = new ImageBinary(0, binary.getWidth(), binary.getHeight());
        BitInputStream bitInputStream = new BitInputStream(binary);
        int valuePixel = 0;
        int width = imageBinary.getWidth();
        int bitCounter = 0;
        int nbInc = 0;
        boolean done = false;
        try {
            while (bitCounter < imageBinary.getBitCount()) {
                byte symbol = (byte)bitInputStream.read(8);
                int command = symbol >> 6 & 3;
                int predicator = symbol >> 5 & 1;
                int nibble = command == 0 ? symbol & 0x3F : symbol & 0x1F;
                nbInc = 0;
                done = false;
                block13: while (!done && bitCounter < imageBinary.getBitCount()) {
                    if (command > 0) {
                        switch (predicator) {
                            case 0: {
                                valuePixel = imageBinary.getPixel(bitCounter % width, bitCounter / width - 1);
                                break;
                            }
                            case 1: {
                                valuePixel = imageBinary.getPixel((bitCounter - 2) % width, (bitCounter - 2) / width);
                                break;
                            }
                        }
                    } else {
                        valuePixel = 0;
                    }
                    switch (command) {
                        case 0: {
                            if (nbInc < 6) {
                                imageBinary.setPixel((symbol & 1 << nbInc) == 1 << nbInc ? 1 : 0, bitCounter % width, bitCounter / width);
                                ++bitCounter;
                                ++nbInc;
                                continue block13;
                            }
                            done = true;
                            continue block13;
                        }
                        case 1: {
                            if (nbInc < nibble + 6) {
                                imageBinary.setPixel(0 ^ valuePixel, bitCounter % width, bitCounter / width);
                                ++bitCounter;
                                ++nbInc;
                            } else {
                                done = true;
                            }
                            if (!done || nibble == 31) continue block13;
                            imageBinary.setPixel(1 ^ valuePixel, bitCounter % width, bitCounter / width);
                            ++bitCounter;
                            continue block13;
                        }
                        case 2: {
                            if (nbInc < nibble + 6) {
                                imageBinary.setPixel(1 ^ valuePixel, bitCounter % width, bitCounter / width);
                                ++bitCounter;
                                ++nbInc;
                            } else {
                                done = true;
                            }
                            if (!done || nibble == 31) continue block13;
                            imageBinary.setPixel(0 ^ valuePixel, bitCounter % width, bitCounter / width);
                            ++bitCounter;
                            continue block13;
                        }
                        case 3: {
                            if (nbInc < (nibble + 2) * 16) {
                                imageBinary.setPixel(0 ^ valuePixel, bitCounter % width, bitCounter / width);
                                ++bitCounter;
                                ++nbInc;
                                continue block13;
                            }
                            done = true;
                            continue block13;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error on data format", exception);
        }
        return imageBinary;
    }
}

