/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc;

import at.mrdevelopment.toolkit.encoding.dc.Binary;
import at.mrdevelopment.toolkit.encoding.dc.BitInputStream;
import at.mrdevelopment.toolkit.encoding.dc.BitOutputStream;
import at.mrdevelopment.toolkit.encoding.dc.CompressionDC;
import at.mrdevelopment.toolkit.encoding.dc.ImageBinary;

public class CompressionDC2
implements CompressionDC {
    private static final int MAX_HEXA_MAX_VALUE = 15;
    private static final int BIT_0_AND_1 = 3;
    private static final int MAX_BIT_COUNT_FOR_COMMAND_3_AFTER_SHIFT = 17;
    private static final int BIT_COUNT_FOR_DATA_LENGTH = 4;
    private static final int MAX_BIT_COUNT_FOR_COMMAND_1_AND_2 = 21;
    private static final int BIT_COUNT_FOR_PREDICATOR_0 = 6;
    private static final int BIT_COUNT_AFTER_COMMAND = 6;
    private static final int BIT_SHIFT_FOR_FOR_COMMAND_3 = 4;
    private static final int COMMAND_3 = 3;
    private static final int COMMAND_2 = 2;
    private static final int COMMAND_1 = 1;
    private static final int COMMAND_0 = 0;
    private static final int BIT_THREE_VALUE = 8;
    private static final int BIT_TWO_VALUE = 4;
    private static final int BIT_ONE_VALUE = 2;
    private static final int PREDICATOR_COUNT = 4;
    private static final int PREDICATOR_3 = 3;
    private static final int PREDICATOR_2 = 2;
    private static final int PREDICATOR_1 = 1;
    private static final int PREDICATOR_0 = 0;
    private static final int BYTE_BIT_COUNT = 8;
    private static final int COMMAND_COUNT = 4;

    @Override
    public Binary compress(ImageBinary binary) {
        int bitReadToCompress;
        BitOutputStream bitOutputStream = new BitOutputStream();
        for (int positionOfBitRead = 0; positionOfBitRead < binary.getBitCount(); positionOfBitRead += bitReadToCompress) {
            bitReadToCompress = 0;
            int[] pixels = new int[4];
            byte data = 0;
            int bestRunLen = 0;
            int bestPred = 0;
            int command = 0;
            for (int indexPredicator = 0; indexPredicator < 4; ++indexPredicator) {
                pixels[0] = 6;
                int[] runLength = new int[4];
                data = this.dryRunCompressAndUpdateRunLength(binary, positionOfBitRead, indexPredicator, runLength);
                this.updatePixels(runLength, pixels);
                for (int c = 0; c < 4; ++c) {
                    if (pixels[c] <= bitReadToCompress) continue;
                    bitReadToCompress = pixels[c];
                    command = c;
                    bestPred = indexPredicator;
                    bestRunLen = runLength[c];
                }
            }
            int symbol = this.getSymbol(data, bestRunLen, bestPred, command);
            bitOutputStream.write(symbol, 8);
        }
        return bitOutputStream.getBinary();
    }

    private byte dryRunCompressAndUpdateRunLength(ImageBinary binary, int positionOfBitRead, int indexPredicator, int[] runLength) {
        byte data = 0;
        byte done = 0;
        int offset = 0;
        while (positionOfBitRead + offset <= binary.getBitCount() && done != 15) {
            int positionY;
            int currentPositionOfBitRead = positionOfBitRead + offset;
            byte value = this.getValueWithCurrentPredicator(binary, indexPredicator, currentPositionOfBitRead);
            int postionX = currentPositionOfBitRead % binary.getWidth();
            byte limitpixel = (byte)(binary.getPixel(postionX, positionY = currentPositionOfBitRead / binary.getWidth()) == 1 ? 1 : 0);
            this.updateRunLength(runLength, done, offset);
            done = this.updateDone(value, limitpixel, done, offset);
            if (offset < 6 && limitpixel != 0) {
                data = (byte)(data | 1 << offset);
            }
            ++offset;
        }
        return data;
    }

    private void updatePixels(int[] runLength, int[] pixels) {
        pixels[1] = runLength[1];
        pixels[2] = runLength[2];
        if (runLength[1] < 21) {
            pixels[1] = pixels[1] + 1;
        }
        if (runLength[2] < 21) {
            pixels[2] = pixels[2] + 1;
        }
        pixels[3] = runLength[3] << 4;
    }

    private byte getValueWithCurrentPredicator(ImageBinary binary, int predicator, int currentPositionOfBitRead) {
        int postionX = currentPositionOfBitRead % binary.getWidth();
        int positionY = currentPositionOfBitRead / binary.getWidth() - 1;
        byte value = 0;
        switch (predicator) {
            case 0: {
                value = (binary.getPixel(postionX, positionY) & 1) == 1 ? (byte)1 : 0;
                break;
            }
            case 1: {
                int bitReadPlus1 = currentPositionOfBitRead + 1;
                int postionX1 = bitReadPlus1 % binary.getWidth();
                int positionY1 = bitReadPlus1 / binary.getWidth();
                value = (byte)(((binary.getPixel(postionX1, positionY1 - 1) & 1) == 1 ? 1 : 0) ^ ((binary.getPixel(postionX, positionY) & 1) == 1 ? 1 : 0));
                break;
            }
            case 2: {
                int bitReadMinus2 = currentPositionOfBitRead - 2;
                int postionX2 = bitReadMinus2 % binary.getWidth();
                int postionY2 = bitReadMinus2 / binary.getWidth();
                value = (binary.getPixel(postionX2, postionY2) & 1) == 1 ? (byte)1 : 0;
                break;
            }
            case 3: {
                int bitReadMinus1 = currentPositionOfBitRead - 1;
                int postionXMinus1 = bitReadMinus1 % binary.getWidth();
                int positionYMinus1 = bitReadMinus1 / binary.getWidth();
                value = (byte)((binary.getPixel(postionXMinus1, positionYMinus1 - 1) > 0 ? 1 : 0) ^ ((binary.getPixel(postionXMinus1, positionYMinus1) & 1) == 1 ? 1 : 0));
                break;
            }
        }
        return value;
    }

    private byte updateDone(byte value, byte limitpixel, byte done, int offset) {
        byte doneResult = done;
        if (offset >= 6) {
            doneResult = (byte)(doneResult | 1);
        }
        if (offset >= 21) {
            doneResult = (byte)(doneResult | 6);
        }
        if (offset >> 4 >= 17) {
            doneResult = (byte)(doneResult | 8);
        }
        if ((limitpixel ^ value) != 0) {
            doneResult = (byte)(doneResult | 0xA);
        }
        if ((limitpixel ^ value) == 0) {
            doneResult = (byte)(doneResult | 4);
        }
        return doneResult;
    }

    private void updateRunLength(int[] runLength, byte done, int offset) {
        if ((done & 2) == 0) {
            runLength[1] = Math.min(21, offset);
        }
        if ((done & 4) == 0) {
            runLength[2] = Math.min(21, offset);
        }
        if ((done & 8) == 0) {
            runLength[3] = Math.min(17, offset >> 4);
        }
    }

    private int getSymbol(byte data, int bestRunLen, int bestPred, int command) {
        int symbol = command << 6 | bestPred << 4;
        switch (command) {
            case 0: {
                symbol = data;
                break;
            }
            case 1: {
                symbol |= bestRunLen - 6;
                break;
            }
            case 2: {
                symbol |= bestRunLen - 6;
                break;
            }
            case 3: {
                symbol |= bestRunLen - 2;
                break;
            }
        }
        return symbol;
    }

    @Override
    public Binary uncompress(ImageBinary binary) {
        ImageBinary imageBinary = new ImageBinary(0, binary.getWidth(), binary.getHeight());
        BitInputStream bitInputStream = new BitInputStream(binary);
        int bitCounter = 0;
        while (bitCounter < imageBinary.getBitCount()) {
            byte symbol = (byte)bitInputStream.read(8);
            bitCounter = this.uncompressByte(imageBinary, bitCounter, symbol);
        }
        return imageBinary;
    }

    private int uncompressByte(ImageBinary imageBinary, int bitIndex, byte symbol) {
        int bitIndexResult = bitIndex;
        int command = this.getCommandInCompressedByte(symbol);
        if (0 == command) {
            bitIndexResult = this.uncompressedCommand0(imageBinary, symbol, bitIndexResult);
        } else {
            int predicator = this.getPredicatorInCompressedByte(symbol);
            int nibble = this.getValueInCompressedByte(symbol, command);
            int width = imageBinary.getWidth();
            int nbInc = 0;
            boolean done = false;
            while (!done && bitIndexResult < imageBinary.getBitCount()) {
                int valuePixel = this.getValuePixelForCommandNon0(imageBinary, width, bitIndexResult, predicator);
                int posX = bitIndexResult % width;
                int posY = bitIndexResult / width;
                switch (command) {
                    case 1: {
                        if (nbInc < nibble + 6) {
                            imageBinary.setPixel(0 ^ valuePixel, posX, posY);
                            ++bitIndexResult;
                            break;
                        }
                        done = true;
                        if (nibble == 15) break;
                        imageBinary.setPixel(1 ^ valuePixel, posX, posY);
                        ++bitIndexResult;
                        break;
                    }
                    case 2: {
                        if (nbInc < nibble + 6) {
                            imageBinary.setPixel(1 ^ valuePixel, posX, posY);
                            ++bitIndexResult;
                            break;
                        }
                        done = true;
                        if (nibble == 15) break;
                        imageBinary.setPixel(0 ^ valuePixel, posX, posY);
                        ++bitIndexResult;
                        break;
                    }
                    case 3: {
                        int countForCommand3 = nibble + 2 << 4;
                        if (nbInc < countForCommand3) {
                            imageBinary.setPixel(0 ^ valuePixel, posX, posY);
                            ++bitIndexResult;
                            break;
                        }
                        done = true;
                        break;
                    }
                }
                ++nbInc;
            }
        }
        return bitIndexResult;
    }

    private int uncompressedCommand0(ImageBinary imageBinary, byte symbol, int bitIndex) {
        int bitIndexResult = bitIndex;
        int width = imageBinary.getWidth();
        for (int nbInc = 0; bitIndexResult < imageBinary.getBitCount() && nbInc < 6; ++bitIndexResult, ++nbInc) {
            int positionX = bitIndexResult % width;
            int positionY = bitIndexResult / width;
            imageBinary.setPixel((symbol & 1 << nbInc) == 1 << nbInc ? 1 : 0, positionX, positionY);
        }
        return bitIndexResult;
    }

    private int getValueInCompressedByte(byte symbol, int command) {
        return command == 0 ? symbol & 3 : symbol & 0xF;
    }

    private int getCommandInCompressedByte(byte symbol) {
        return symbol >> 6 & 3;
    }

    private int getPredicatorInCompressedByte(byte symbol) {
        return symbol >> 4 & 3;
    }

    private int getValuePixelForCommandNon0(ImageBinary imageBinary, int width, int bitIndex, int predicator) {
        int valuePixel = 0;
        switch (predicator) {
            case 0: {
                valuePixel = imageBinary.getPixel(bitIndex % width, bitIndex / width - 1);
                break;
            }
            case 1: {
                valuePixel = imageBinary.getPixel((bitIndex + 1) % width, (bitIndex + 1) / width - 1) ^ imageBinary.getPixel(bitIndex % width, bitIndex / width - 1);
                break;
            }
            case 2: {
                valuePixel = imageBinary.getPixel((bitIndex - 2) % width, (bitIndex - 2) / width);
                break;
            }
            case 3: {
                valuePixel = imageBinary.getPixel((bitIndex - 1) % width, (bitIndex - 1) / width - 1) ^ imageBinary.getPixel((bitIndex - 1) % width, (bitIndex - 1) / width);
                break;
            }
        }
        return valuePixel;
    }
}

