/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc;

import at.mrdevelopment.toolkit.encoding.dc.Binary;
import at.mrdevelopment.toolkit.encoding.dc.BitInputStream;
import at.mrdevelopment.toolkit.encoding.dc.MathUtil;
import java.util.Deque;
import java.util.LinkedList;

public class BitOutputStream {
    private static final int BIT_COUNT_IN_BYTE = 8;
    private static final int MAX_BIT_POSITION_IN_BYTE = 7;
    private final Deque<Byte> list = new LinkedList<Byte>();
    private int bitIndex = 7;
    private byte byteValue = 0;
    private int bitCount = 0;

    public BitOutputStream() {
    }

    public BitOutputStream(int bitCount, byte[] content) {
        this();
        int contentFullByteLength = content.length - (bitCount % 8 == 0 ? 0 : 1);
        for (int i = 0; i < contentFullByteLength; ++i) {
            this.list.add(content[i]);
        }
        this.bitCount = bitCount;
        if (bitCount % 8 == 0) {
            this.bitIndex = 7;
            this.byteValue = 0;
        } else {
            this.bitIndex = 7 - bitCount % 8;
            this.byteValue = content[content.length - 1];
        }
    }

    public BitOutputStream(Binary binaryValue) {
        this(binaryValue.getBitCount(), binaryValue.getData());
    }

    public void write(int value) {
        if (value != 0 && value != 1) {
            throw new IllegalArgumentException("value must be 0 or 1");
        }
        if (value == 1) {
            this.byteValue = (byte)(this.byteValue | 1 << this.bitIndex);
        }
        if (--this.bitIndex < 0) {
            this.list.addLast(this.byteValue);
            this.bitIndex = 7;
            this.byteValue = 0;
        }
        ++this.bitCount;
    }

    public void write(long value) {
        if (value != 0L && value != 1L) {
            throw new IllegalArgumentException("value must be 0 or 1");
        }
        if (value == 1L) {
            this.byteValue = (byte)(this.byteValue | 1 << this.bitIndex);
        }
        if (--this.bitIndex < 0) {
            this.list.addLast(this.byteValue);
            this.bitIndex = 7;
            this.byteValue = 0;
        }
        ++this.bitCount;
    }

    public void write(int value, int pBitCount) {
        if (MathUtil.bitCount(value) > pBitCount) {
            throw new IllegalArgumentException(value + " is not encodable into " + pBitCount + "bits");
        }
        for (int inValueBitIndex = pBitCount - 1; inValueBitIndex >= 0; --inValueBitIndex) {
            int bitValue = value >> inValueBitIndex & 1;
            this.write(bitValue);
        }
    }

    public void write(long value, int pBitCount) {
        if (MathUtil.bitCount(value) > pBitCount) {
            throw new IllegalArgumentException(value + " is not encodable into " + pBitCount + "bits");
        }
        for (int inValueBitIndex = pBitCount - 1; inValueBitIndex >= 0; --inValueBitIndex) {
            long bitValue = value >> inValueBitIndex & 1L;
            this.write(bitValue);
        }
    }

    public void write(Binary binary) {
        int value;
        BitInputStream input = new BitInputStream(binary);
        while ((value = input.read()) != -1) {
            this.write(value);
        }
    }

    public int readValueAt(int bitPosition) {
        if (bitPosition > this.bitCount) {
            throw new IllegalArgumentException("Out of range position : " + bitPosition + " bitCount : " + this.bitCount);
        }
        int byteIndex = bitPosition / 8;
        int aBitIndex = 7 - bitPosition % 8;
        Byte currentByte = (Byte)((LinkedList)this.list).get(byteIndex);
        int valueBit = currentByte >> aBitIndex & 1;
        return valueBit;
    }

    public byte[] toArray() {
        int size = this.list.size() + (this.bitIndex == 7 ? 0 : 1);
        byte[] array = new byte[size];
        int index = 0;
        for (byte element : this.list) {
            array[index++] = element;
        }
        if (this.bitIndex != 7) {
            array[index] = this.byteValue;
        }
        return array;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public Binary getBinary() {
        return new Binary(this.bitCount, this.toArray());
    }
}

