/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.encoding.NoEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleByteRunLengthEncoding;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.RawImage;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class UseMostEfficientEncoding
implements DataEncoding {
    private final List<DataEncoding> encodings;

    public static DataEncoding newSimpleByteRunLengthOrNone() {
        return new UseMostEfficientEncoding(Arrays.asList(new NoEncoding(), new SimpleByteRunLengthEncoding()));
    }

    public UseMostEfficientEncoding(Iterable<DataEncoding> encodings) {
        Preconditions.checkArgument((!Iterables.isEmpty(encodings) ? 1 : 0) != 0);
        this.encodings = Lists.newArrayList(encodings);
    }

    @Override
    public EncodedImage encode(RawImage decoded) {
        EncodedImage smallest = null;
        for (DataEncoding encoding : this.encodings) {
            EncodedImage encoded = encoding.encode(decoded);
            if (smallest != null && encoded.getEncodedSize() >= smallest.getEncodedSize()) continue;
            smallest = encoded;
        }
        return smallest;
    }

    @Override
    public RawImage decode(EncodedImage encoded) {
        throw new UnsupportedOperationException();
    }
}

