/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.collection.ByteArrayList;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.EncodedImageFactory;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public class SimpleThreeByteRunLengthEncoding
implements DataEncoding {
    private static final byte MAGIC_NUMBER = -86;

    @Override
    public EncodedImage encode(RawImage decoded) {
        byte[] decodedData = decoded.getBytes();
        int decodedLength = decodedData.length;
        ThreeByteRunLength rle = new ThreeByteRunLength(decodedLength);
        for (int index = 0; index < decodedLength; ++index) {
            byte value = decodedData[index];
            if (decodedData[index] == rle.value) {
                if (rle.runLength == 256) {
                    rle.write();
                }
            } else {
                rle.write();
                rle.value = value;
            }
            ++rle.runLength;
        }
        rle.write();
        return EncodedImageFactory.newImage(decoded.getWidth(), decoded.getHeight(), rle.toArray(), decoded.getType(), decoded.getColorMappings());
    }

    @Override
    public RawImage decode(EncodedImage encoded) {
        byte[] encodedData = encoded.getEncodedBytes();
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        int position = 0;
        int index = 0;
        while (index < encoded.getEncodedSize()) {
            byte value;
            if ((value = encodedData[index++]) == -86) {
                value = encodedData[index++];
                int runLength = (encodedData[index++] & 0xFF) + 1;
                for (int offset = 0; offset < runLength; ++offset) {
                    decoded.add(position + offset, value);
                }
                position += runLength;
                continue;
            }
            decoded.add(position++, value);
        }
        return RawImageFactory.newImage(encoded.getDecodedWidth(), encoded.getDecodedHeight(), ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()])), encoded.getDecodedType(), encoded.getDecodedColorMappings());
    }

    private static class ThreeByteRunLength {
        byte value = 0;
        int runLength = 0;
        private final ByteArrayList data;

        ThreeByteRunLength(int initialCapacity) {
            this.data = new ByteArrayList(initialCapacity);
        }

        public void write() {
            if (this.value != -86 && this.runLength == 1) {
                this.data.add(this.value);
            } else if (this.runLength > 0) {
                this.data.add((byte)-86);
                this.data.add(this.value);
                this.data.add((byte)(this.runLength - 1));
            }
            this.runLength = 0;
        }

        public byte[] toArray() {
            return this.data.toArray();
        }
    }
}

