/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.collection.ByteArrayList;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.EncodedImageFactory;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public class SimpleByteRunLengthEncoding
implements DataEncoding {
    @Override
    public EncodedImage encode(RawImage decoded) {
        byte[] decodedData = decoded.getBytes();
        int decodedLength = decodedData.length;
        ByteRunLength rle = new ByteRunLength(decodedLength);
        for (int index = 0; index < decodedLength; ++index) {
            byte value = decodedData[index];
            if (decodedData[index] == rle.value) {
                if (rle.runLength == 256) {
                    rle.write();
                }
            } else {
                rle.write();
                rle.value = value;
            }
            ++rle.runLength;
        }
        rle.write();
        return EncodedImageFactory.newImage(decoded.getWidth(), decoded.getHeight(), rle.toArray(), decoded.getType(), decoded.getColorMappings());
    }

    @Override
    public RawImage decode(EncodedImage encoded) {
        byte[] encodedData = encoded.getEncodedBytes();
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        int position = 0;
        for (int index = 0; index < encoded.getEncodedSize(); index += 2) {
            byte value = encodedData[index];
            int runLength = (encodedData[index + 1] & 0xFF) + 1;
            for (int offset = 0; offset < runLength; ++offset) {
                decoded.add(position + offset, value);
            }
            position += runLength;
        }
        return RawImageFactory.newImage(encoded.getDecodedWidth(), encoded.getDecodedHeight(), ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()])), encoded.getDecodedType(), encoded.getDecodedColorMappings());
    }

    private static class ByteRunLength {
        byte value = 0;
        int runLength = 0;
        private final ByteArrayList data;

        ByteRunLength(int initialCapacity) {
            this.data = new ByteArrayList(initialCapacity);
        }

        public void write() {
            if (this.runLength > 0) {
                this.data.add(this.value);
                this.data.add((byte)(this.runLength - 1));
                this.runLength = 0;
            }
        }

        public byte[] toArray() {
            return this.data.toArray();
        }
    }
}

