/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.collection.ByteArrayList;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.EncodedImageFactory;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public class SimpleBitRunLengthEncoding
implements DataEncoding {
    @Override
    public EncodedImage encode(RawImage decoded) {
        byte[] decodedData = decoded.getBytes();
        int decodedLength = decodedData.length;
        BitRunLength rle = new BitRunLength(decodedLength);
        for (int index = 0; index < decodedLength; ++index) {
            for (int bit = 0; bit < 8; ++bit) {
                boolean value;
                boolean bl = value = (decodedData[index] & 1 << bit) != 0;
                if (value == rle.value) {
                    if (rle.runLength == 128) {
                        rle.write();
                    }
                } else {
                    rle.write();
                    rle.value = value;
                }
                ++rle.runLength;
            }
        }
        rle.write();
        return EncodedImageFactory.newImage(decoded.getWidth(), decoded.getHeight(), rle.toArray(), decoded.getType(), decoded.getColorMappings());
    }

    @Override
    public RawImage decode(EncodedImage encoded) {
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        int position = 0;
        byte data = 0;
        for (byte rleByte : encoded.getEncodedBytes()) {
            boolean value = (rleByte & 0x80) != 0;
            int runLength = (rleByte & 0x7F) + 1;
            for (int offset = 0; offset < runLength; ++offset) {
                int index = position + offset;
                int bitValue = value ? 1 : 0;
                data = (byte)(data | bitValue << index % 8);
                if (index % 8 != 7) continue;
                decoded.add(index / 8, data);
                data = 0;
            }
            position += runLength;
        }
        return RawImageFactory.newImage(encoded.getDecodedWidth(), encoded.getDecodedHeight(), ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()])), encoded.getDecodedType(), encoded.getDecodedColorMappings());
    }

    private static class BitRunLength {
        private final ByteArrayList data;
        boolean value = false;
        int runLength = 0;

        BitRunLength(int initialCapacity) {
            this.data = new ByteArrayList(initialCapacity);
        }

        public void write() {
            if (this.runLength > 0) {
                byte encoded = this.encode(this.value, this.runLength);
                this.data.add(encoded);
                this.runLength = 0;
            }
        }

        private byte encode(boolean value, int runLength) {
            return (byte)((value ? -128 : 0) | (byte)(runLength - 1));
        }

        public byte[] toArray() {
            return this.data.toArray();
        }
    }
}

