/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.encoding.CompressionMode;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.encoding.dc.CompressionDC;
import at.mrdevelopment.toolkit.encoding.dc.ImageBinary;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.EncodedImageFactory;
import at.mrdevelopment.toolkit.image.EncodedImageProperties;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageType;
import org.apache.commons.lang.ArrayUtils;

public class DCEncoding
implements DataEncoding {
    private final CompressionDC compression;

    public DCEncoding(CompressionDC compression) {
        this.compression = compression;
    }

    @Override
    public EncodedImage encode(RawImage decoded) {
        RawImageType type = decoded.getType();
        if (!type.equals((Object)RawImageType.TYPE_BINARY) && !type.equals((Object)RawImageType.LINED_UP_IMAGES)) {
            throw new UnsupportedOperationException(String.format("Image Type not supported: %s", type.name()));
        }
        int decodedImageHeight = decoded.getHeight();
        CompressionMode compressionMode = CompressionMode.DC3_SC;
        if (type.equals((Object)RawImageType.LINED_UP_IMAGES) && !decoded.getRawImageProperties().isWhite()) {
            decodedImageHeight *= 2;
            compressionMode = CompressionMode.DC3_MC;
        }
        byte[] encodedImage = this.encodeImage(new ImageBinary(decoded.getBytes(), decoded.getWidth(), decodedImageHeight));
        return EncodedImageFactory.newImage(decoded.getWidth(), decoded.getHeight(), encodedImage, type, new EncodedImageProperties(compressionMode), decoded.getColorMappings());
    }

    @Override
    public RawImage decode(EncodedImage encoded) {
        RawImageType type = encoded.getDecodedType();
        CompressionMode compressionMode = encoded.getEncodedImageProperties().getCompressionMode();
        if (!type.equals((Object)RawImageType.TYPE_BINARY) && !type.equals((Object)RawImageType.LINED_UP_IMAGES)) {
            throw new UnsupportedOperationException(String.format("Image type not supported: %s", type.name()));
        }
        if (!compressionMode.equals((Object)CompressionMode.DC3_MC) && !compressionMode.equals((Object)CompressionMode.DC3_SC)) {
            throw new UnsupportedOperationException(String.format("DC3 mode not supported: %s", compressionMode.name()));
        }
        int decodedImageHeight = encoded.getDecodedHeight();
        byte[] white = new byte[]{};
        if (type.equals((Object)RawImageType.LINED_UP_IMAGES)) {
            if (compressionMode.equals((Object)CompressionMode.DC3_SC)) {
                white = new byte[type.getImageSize(encoded.getDecodedWidth(), encoded.getDecodedHeight()) / 2];
            } else {
                decodedImageHeight *= 2;
            }
        }
        byte[] decodedImage = this.decodeImage(new ImageBinary(encoded.getEncodedBytes(), encoded.getDecodedWidth(), decodedImageHeight));
        return RawImageFactory.newImage(encoded.getDecodedWidth(), encoded.getDecodedHeight(), ArrayUtils.addAll((byte[])decodedImage, (byte[])white), type, encoded.getDecodedColorMappings());
    }

    private byte[] encodeImage(ImageBinary imageBinary) {
        return this.compression.compress(imageBinary).getData();
    }

    private byte[] decodeImage(ImageBinary imageBinary) {
        return this.compression.uncompress(imageBinary).getData();
    }
}

